/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.BiomeDetectorBase;
import hunternif.mc.impl.atlas.core.IBiomeDetector;
import hunternif.mc.impl.atlas.ext.ExtTileIdMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.IChunk;

public class BiomeDetectorNether
extends BiomeDetectorBase
implements IBiomeDetector {
    private static final int airProbeLevel = 50;
    private static final int lavaSeaLevel = 31;
    private static final int priorityLava = 1;

    @Override
    public ResourceLocation getBiomeID(World world, IChunk chunk) {
        BiomeContainer chunkBiomes = chunk.func_225549_i_();
        if (chunkBiomes == null) {
            return null;
        }
        HashMap<ResourceLocation, Integer> biomeOccurrences = new HashMap<ResourceLocation, Integer>(WorldGenRegistries.field_243657_i.func_148742_b().size());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = chunkBiomes.func_225526_b_(x, 31, z);
                if (biome.func_201856_r() == Biome.Category.NETHER) {
                    Block netherBlock = chunk.func_180495_p(new BlockPos(x, 31, z)).func_177230_c();
                    if (netherBlock == Blocks.field_150353_l) {
                        BiomeDetectorNether.updateOccurrencesMap(biomeOccurrences, ExtTileIdMap.TILE_LAVA, 1);
                        continue;
                    }
                    BlockState netherBlockState = chunk.func_180495_p(new BlockPos(x, 50, z));
                    if (netherBlockState.func_196958_f()) {
                        BiomeDetectorNether.updateOccurrencesMap(biomeOccurrences, ExtTileIdMap.TILE_LAVA_SHORE, 1);
                        continue;
                    }
                    BiomeDetectorNether.updateOccurrencesMap(biomeOccurrences, world, biome, 1);
                    continue;
                }
                BiomeDetectorNether.updateOccurrencesMap(biomeOccurrences, world, biome, this.priorityForBiome(biome));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (ResourceLocation)meanBiome.getKey();
    }
}

