/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.ext;

import hunternif.mc.impl.atlas.network.packet.s2c.play.CustomTileInfoS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.ShortVec2;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class TileDataStorage
extends WorldSavedData {
    private static final int VERSION = 3;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_WORLD_ID = "worldID";
    private static final String TAG_TILE_LIST = "tiles";
    private final Map<ShortVec2, ResourceLocation> tiles = new ConcurrentHashMap<ShortVec2, ResourceLocation>(2, 0.75f, 2);
    private final ShortVec2 tempCoords = new ShortVec2(0, 0);

    public TileDataStorage(String key) {
        super(key);
    }

    public void func_76184_a(CompoundNBT compound) {
        int version = compound.func_74762_e(TAG_VERSION);
        if (version < 3) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 3);
            this.func_76185_a();
        }
        ListNBT tileList = compound.func_150295_c(TAG_TILE_LIST, 10);
        tileList.stream().forEach(tag1 -> {
            CompoundNBT tile = (CompoundNBT)tag1;
            ShortVec2 coords = new ShortVec2(tile.func_74762_e("x"), tile.func_74762_e("y"));
            this.tiles.put(coords, ResourceLocation.func_208304_a((String)tile.func_74779_i("id")));
        });
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a(TAG_VERSION, 3);
        ListNBT tileList = new ListNBT();
        for (Map.Entry<ShortVec2, ResourceLocation> entry : this.tiles.entrySet()) {
            CompoundNBT tile = new CompoundNBT();
            tile.func_74768_a("x", (int)entry.getKey().x);
            tile.func_74768_a("y", (int)entry.getKey().y);
            tile.func_74778_a("id", entry.getValue().toString());
            tileList.add((Object)tile);
        }
        compound.func_218657_a(TAG_TILE_LIST, (INBT)tileList);
        return compound;
    }

    public ResourceLocation getTile(int x, int z) {
        return this.tiles.get(this.tempCoords.set(x, z));
    }

    public void setTile(int x, int z, ResourceLocation tile) {
        this.tiles.put(new ShortVec2(x, z), tile);
        this.func_76185_a();
    }

    public void removeTile(int x, int z) {
        this.tiles.remove(this.tempCoords.set(x, z));
        this.func_76185_a();
    }

    public void syncToPlayer(ServerPlayerEntity player, RegistryKey<World> world) {
        new CustomTileInfoS2CPacket(world, this.tiles).send(player);
        Log.info("Sent custom biome data to player %s", player.func_195051_bN().func_197037_c());
    }
}

