/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.ext.watcher;

import com.google.common.collect.Sets;
import hunternif.mc.impl.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.impl.atlas.ext.watcher.WatcherPos;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcher {
    public static final StructureWatcher INSTANCE = new StructureWatcher();
    private final Set<IStructureWatcher> structureWatchers = Sets.newHashSet();

    public static void handlePotential(ServerWorld world) {
        for (IStructureWatcher watcher : StructureWatcher.INSTANCE.structureWatchers) {
            CompoundNBT structureData;
            if (!watcher.isDimensionValid(world) || (structureData = watcher.getStructureData(world)) == null) continue;
            Set<Pair<WatcherPos, String>> visited = watcher.visitStructure((World)world, structureData);
            for (Pair<WatcherPos, String> visit : visited) {
                Log.info("Visited %s in dimension %s at %s", visit.getRight(), world.func_230315_m_().toString(), ((WatcherPos)visit.getLeft()).toString());
            }
        }
    }

    public static void handleShutdown() {
        for (IStructureWatcher watcher : StructureWatcher.INSTANCE.structureWatchers) {
            watcher.getVisited().clear();
        }
    }

    public void addWatcher(IStructureWatcher watcher) {
        this.structureWatchers.add(watcher);
    }
}

