/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.forge.IResourceReloadListener;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MarkerTextureConfig
implements IResourceReloadListener<Map<ResourceLocation, MarkerType>> {
    private static final int VERSION = 1;
    private static final JsonParser parser = new JsonParser();

    @Override
    public CompletableFuture<Map<ResourceLocation, MarkerType>> load(IResourceManager manager, IProfiler profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, MarkerType> typeMap = new HashMap<ResourceLocation, MarkerType>();
            for (ResourceLocation id : manager.func_199003_a("marker_types", s -> s.endsWith(".json"))) {
                if (!id.func_110624_b().equals("antiqueatlas")) continue;
                ResourceLocation markerId = new ResourceLocation(id.func_110624_b(), id.func_110623_a().replace("marker_types/", "").replace(".json", ""));
                try {
                    IResource resource = manager.func_199002_a(id);
                    InputStream stream = resource.func_199027_b();
                    Throwable throwable = null;
                    try {
                        InputStreamReader reader = new InputStreamReader(stream);
                        Throwable throwable2 = null;
                        try {
                            JsonObject object = parser.parse((Reader)reader).getAsJsonObject();
                            MarkerType markerType = new MarkerType(markerId);
                            markerType.getJSONData().readFrom(object);
                            markerType.setIsFromJson(true);
                            typeMap.put(markerId, markerType);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable2 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (Exception e) {
                    AntiqueAtlasMod.LOG.warn("Error reading marker " + markerId + "!", (Throwable)e);
                }
            }
            return typeMap;
        });
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, MarkerType> data, IResourceManager manager, IProfiler profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (ResourceLocation markerId : data.keySet()) {
                MarkerType.register(markerId, (MarkerType)data.get(markerId));
            }
        });
    }
}

