/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.network.packet.s2c.play.MarkersS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class MarkersData
extends WorldSavedData {
    private static final int VERSION = 4;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_WORLD_MAP_LIST = "worldMap";
    private static final String TAG_WORLD_ID = "worldID";
    private static final String TAG_MARKERS = "markers";
    private static final String TAG_MARKER_ID = "id";
    private static final String TAG_MARKER_TYPE = "markerType";
    private static final String TAG_MARKER_LABEL = "label";
    private static final String TAG_MARKER_X = "x";
    private static final String TAG_MARKER_Y = "y";
    private static final String TAG_MARKER_VISIBLE_AHEAD = "visAh";
    public static final int CHUNK_STEP = 8;
    private final Set<PlayerEntity> playersSentTo = new HashSet<PlayerEntity>();
    private final AtomicInteger largestID = new AtomicInteger(0);
    private final Map<Integer, Marker> idMap = new ConcurrentHashMap<Integer, Marker>(2, 0.75f, 2);
    private final Map<RegistryKey<World>, DimensionMarkersData> worldMap = new ConcurrentHashMap<RegistryKey<World>, DimensionMarkersData>(2, 0.75f, 2);

    private int getNewID() {
        return this.largestID.incrementAndGet();
    }

    public MarkersData(String key) {
        super(key);
    }

    public void func_76184_a(CompoundNBT compound) {
        int version = compound.func_74762_e(TAG_VERSION);
        if (version < 4) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 4);
            this.func_76185_a();
        }
        ListNBT dimensionMapList = compound.func_150295_c(TAG_WORLD_MAP_LIST, 10);
        for (int d = 0; d < dimensionMapList.size(); ++d) {
            CompoundNBT tag = dimensionMapList.func_150305_b(d);
            RegistryKey world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i(TAG_WORLD_ID)));
            ListNBT tagList = tag.func_150295_c(TAG_MARKERS, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                int id;
                CompoundNBT markerTag = tagList.func_150305_b(i);
                boolean visibleAhead = true;
                if (version < 2) {
                    Log.warn("Marker is visible ahead by default", new Object[0]);
                } else {
                    visibleAhead = markerTag.func_74767_n(TAG_MARKER_VISIBLE_AHEAD);
                }
                if (version < 3) {
                    id = this.getNewID();
                } else {
                    id = markerTag.func_74762_e(TAG_MARKER_ID);
                    if (this.getMarkerByID(id) != null) {
                        Log.warn("Loading marker with duplicate id %d. Getting new id", id);
                        id = this.getNewID();
                    }
                    this.func_76185_a();
                }
                if (this.largestID.intValue() < id) {
                    this.largestID.set(id);
                }
                Marker marker = new Marker(id, new ResourceLocation(markerTag.func_74779_i(TAG_MARKER_TYPE)), (ITextComponent)ITextComponent.Serializer.func_240643_a_((String)markerTag.func_74779_i(TAG_MARKER_LABEL)), (RegistryKey<World>)world, markerTag.func_74762_e(TAG_MARKER_X), markerTag.func_74762_e(TAG_MARKER_Y), visibleAhead);
                this.loadMarker(marker);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        Log.info("Saving local markers data to NBT", new Object[0]);
        compound.func_74768_a(TAG_VERSION, 4);
        ListNBT dimensionMapList = new ListNBT();
        for (RegistryKey<World> world : this.worldMap.keySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a(TAG_WORLD_ID, world.func_240901_a_().toString());
            DimensionMarkersData data = this.getMarkersDataInWorld(world);
            ListNBT tagList = new ListNBT();
            for (Marker marker : data.getAllMarkers()) {
                CompoundNBT markerTag = new CompoundNBT();
                markerTag.func_74768_a(TAG_MARKER_ID, marker.getId());
                markerTag.func_74778_a(TAG_MARKER_TYPE, marker.getType().toString());
                markerTag.func_74778_a(TAG_MARKER_LABEL, ITextComponent.Serializer.func_150696_a((ITextComponent)marker.getLabel()));
                markerTag.func_74768_a(TAG_MARKER_X, marker.getX());
                markerTag.func_74768_a(TAG_MARKER_Y, marker.getZ());
                markerTag.func_74757_a(TAG_MARKER_VISIBLE_AHEAD, marker.isVisibleAhead());
                tagList.add((Object)markerTag);
            }
            tag.func_218657_a(TAG_MARKERS, (INBT)tagList);
            dimensionMapList.add((Object)tag);
        }
        compound.func_218657_a(TAG_WORLD_MAP_LIST, (INBT)dimensionMapList);
        return compound;
    }

    public Set<RegistryKey<World>> getVisitedDimensions() {
        return this.worldMap.keySet();
    }

    public Collection<Marker> getMarkersInDimension(RegistryKey<World> world) {
        return this.getMarkersDataInWorld(world).getAllMarkers();
    }

    public DimensionMarkersData getMarkersDataInWorld(RegistryKey<World> world) {
        return this.worldMap.computeIfAbsent(world, k -> new DimensionMarkersData(this, world));
    }

    public List<Marker> getMarkersAtChunk(RegistryKey<World> world, int x, int z) {
        return this.getMarkersDataInWorld(world).getMarkersAtChunk(x, z);
    }

    private Marker getMarkerByID(int id) {
        return this.idMap.get(id);
    }

    public Marker removeMarker(int id) {
        Marker marker = this.getMarkerByID(id);
        if (marker == null) {
            return null;
        }
        if (this.idMap.remove(id) != null) {
            this.getMarkersDataInWorld(marker.getWorld()).removeMarker(marker);
            this.func_76185_a();
        }
        return marker;
    }

    public Marker createAndSaveMarker(ResourceLocation type, RegistryKey<World> world, int x, int z, boolean visibleAhead, ITextComponent label) {
        Marker marker = new Marker(this.getNewID(), type, label, world, x, z, visibleAhead);
        Log.info("Created new marker %s", marker.toString());
        this.idMap.put(marker.getId(), marker);
        this.getMarkersDataInWorld(world).insertMarker(marker);
        this.func_76185_a();
        return marker;
    }

    public Marker loadMarker(Marker marker) {
        if (!this.idMap.containsKey(marker.getId())) {
            this.idMap.put(marker.getId(), marker);
            int totalMarkers = 0;
            for (Map.Entry<RegistryKey<World>, DimensionMarkersData> e : this.worldMap.entrySet()) {
                totalMarkers += e.getValue().getAllMarkers().size();
            }
            if (totalMarkers < (Integer)AntiqueAtlasConfig.markerLimit.get()) {
                this.getMarkersDataInWorld(marker.getWorld()).insertMarker(marker);
            } else {
                Log.warn("Could not add new marker. Atlas is at it's limit of %d markers", AntiqueAtlasConfig.markerLimit.get());
            }
        }
        return marker;
    }

    public boolean isSyncedOnPlayer(PlayerEntity player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, ServerPlayerEntity player) {
        for (RegistryKey<World> world : this.worldMap.keySet()) {
            DimensionMarkersData data = this.getMarkersDataInWorld(world);
            new MarkersS2CPacket(atlasID, world, data.getAllMarkers()).send(player);
        }
        Log.info("Sent markers data #%d to player %s", atlasID, player.func_195051_bN().func_197037_c());
        this.playersSentTo.add((PlayerEntity)player);
    }

    public boolean isEmpty() {
        return this.idMap.isEmpty();
    }
}

