/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.api.AtlasAPI;
import hunternif.mc.impl.atlas.network.packet.c2s.C2SPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class BrowsingPositionC2SPacket
extends C2SPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "c2s", "browsing_position");
    int atlasID;
    RegistryKey<World> world;
    int x;
    int y;
    double zoom;

    public BrowsingPositionC2SPacket(int atlasID, RegistryKey<World> world, int x, int y, double zoom) {
        this.atlasID = atlasID;
        this.world = world;
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    public static void encode(BrowsingPositionC2SPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(msg.atlasID);
        packetBuffer.func_192572_a(msg.world.func_240901_a_());
        packetBuffer.func_150787_b(msg.x);
        packetBuffer.func_150787_b(msg.y);
        packetBuffer.writeDouble(msg.zoom);
    }

    public static BrowsingPositionC2SPacket decode(PacketBuffer packetBuffer) {
        return new BrowsingPositionC2SPacket(packetBuffer.func_150792_a(), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)packetBuffer.func_192575_l()), packetBuffer.func_150792_a(), packetBuffer.func_150792_a(), packetBuffer.readDouble());
    }

    public static void handle(BrowsingPositionC2SPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (((Boolean)AntiqueAtlasConfig.itemNeeded.get()).booleanValue() && !AtlasAPI.getPlayerAtlases((PlayerEntity)context.getSender()).contains(msg.atlasID)) {
                Log.warn("Player %s attempted to put position marker into someone else's Atlas #%d", context.getSender().func_195051_bN().func_197037_c(), msg.atlasID);
                return;
            }
            AntiqueAtlasMod.atlasData.getAtlasData(msg.atlasID, context.getSender().func_130014_f_()).getWorldData(msg.world).setBrowsingPosition(msg.x, msg.y, msg.zoom);
        });
        context.setPacketHandled(true);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

