/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.ext.TileDataStorage;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import hunternif.mc.impl.atlas.util.ShortVec2;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomTileInfoS2CPacket
extends S2CPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "custom_tile", "info");
    RegistryKey<World> world;
    Map<ShortVec2, ResourceLocation> tiles;

    public CustomTileInfoS2CPacket(RegistryKey<World> world, Map<ShortVec2, ResourceLocation> tiles) {
        this.world = world;
        this.tiles = tiles;
    }

    public CustomTileInfoS2CPacket(RegistryKey<World> world, int chunkX, int chunkZ, ResourceLocation tileId) {
        this.world = world;
        this.tiles = new ImmutableMap.Builder().put((Object)new ShortVec2(chunkX, chunkZ), (Object)tileId).build();
    }

    public static void encode(CustomTileInfoS2CPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_192572_a(msg.world.func_240901_a_());
        packetBuffer.func_150787_b(msg.tiles.size());
        for (Map.Entry<ShortVec2, ResourceLocation> entry : msg.tiles.entrySet()) {
            packetBuffer.writeShort((int)entry.getKey().x);
            packetBuffer.writeShort((int)entry.getKey().y);
            packetBuffer.func_192572_a(entry.getValue());
        }
    }

    public static CustomTileInfoS2CPacket decode(PacketBuffer packetBuffer) {
        RegistryKey world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)packetBuffer.func_192575_l());
        int tileCount = packetBuffer.func_150792_a();
        HashMap tiles = Maps.newHashMap();
        for (int i = 0; i < tileCount; ++i) {
            tiles.put(new ShortVec2((int)packetBuffer.readShort(), (int)packetBuffer.readShort()), packetBuffer.func_192575_l());
        }
        return new CustomTileInfoS2CPacket((RegistryKey<World>)world, tiles);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean handle(ClientPlayerEntity player) {
        TileDataStorage data = AntiqueAtlasMod.tileData.getData(this.world);
        for (Map.Entry<ShortVec2, ResourceLocation> entry : this.tiles.entrySet()) {
            data.setTile(entry.getKey().x, entry.getKey().y, entry.getValue());
        }
        return true;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

