/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.google.common.collect.Sets;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.ext.ExtTileTextureMap;
import hunternif.mc.impl.atlas.forge.hook.AntiqueAtlasHooks;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileNameS2CPacket
extends S2CPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "c2s", "tile", "update");
    Collection<ResourceLocation> tileIds;

    public TileNameS2CPacket(Collection<ResourceLocation> tileIds) {
        this.tileIds = tileIds;
    }

    public TileNameS2CPacket(ResourceLocation id) {
        this.tileIds = Sets.newHashSet((Object[])new ResourceLocation[]{id});
    }

    public static void encode(TileNameS2CPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(msg.tileIds.size());
        for (ResourceLocation id : msg.tileIds) {
            packetBuffer.func_192572_a(id);
        }
    }

    public static TileNameS2CPacket decode(PacketBuffer packetBuffer) {
        int size = packetBuffer.func_150792_a();
        HashSet<ResourceLocation> tileIds = new HashSet<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            tileIds.add(packetBuffer.func_192575_l());
        }
        return new TileNameS2CPacket(tileIds);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean handle(ClientPlayerEntity player) {
        for (ResourceLocation id : this.tileIds) {
            TextureSet texture = ExtTileTextureMap.instance().getTexture(id);
            BiomeTextureMap.instance().setTexture(id, texture);
        }
        AntiqueAtlasHooks.fireTileIdRegistered(this.tileIds);
        return true;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

