/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.structure;

import com.google.common.collect.HashMultimap;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.api.AtlasAPI;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.MathUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;

public class StructureHandler {
    private static final HashMultimap<ResourceLocation, Tuple<ResourceLocation, Setter>> STRUCTURE_PIECE_TO_TILE_MAP = HashMultimap.create();
    private static final HashMap<ResourceLocation, Tuple<ResourceLocation, ITextComponent>> STRUCTURE_PIECE_TO_MARKER_MAP = new HashMap();
    private static final HashMap<ResourceLocation, Integer> STRUCTURE_PIECE_TILE_PRIORITY = new HashMap();
    private static final Setter ALWAYS = box -> Collections.singleton(new ChunkPos(MathUtil.getCenter(box).func_177958_n() >> 4, MathUtil.getCenter(box).func_177952_p() >> 4));

    public static void registerTile(IStructurePieceType structurePieceType, int priority, ResourceLocation textureId, Setter setter) {
        ResourceLocation id = Registry.field_218362_C.func_177774_c((Object)structurePieceType);
        STRUCTURE_PIECE_TO_TILE_MAP.put((Object)id, (Object)new Tuple((Object)textureId, (Object)setter));
        STRUCTURE_PIECE_TILE_PRIORITY.put(id, priority);
    }

    public static void registerTile(IStructurePieceType structurePieceType, int priority, ResourceLocation textureId) {
        StructureHandler.registerTile(structurePieceType, priority, textureId, ALWAYS);
    }

    public static void registerMarker(Structure<?> structureFeature, ResourceLocation markerType, ITextComponent name) {
        STRUCTURE_PIECE_TO_MARKER_MAP.put(Registry.field_218361_B.func_177774_c(structureFeature), (Tuple<ResourceLocation, ITextComponent>)new Tuple((Object)markerType, (Object)name));
    }

    private static int getPriority(ResourceLocation structurePieceId) {
        return STRUCTURE_PIECE_TILE_PRIORITY.getOrDefault(structurePieceId, Integer.MAX_VALUE);
    }

    private static void put(ResourceLocation structurePieceId, World world, int chunkX, int chunkZ, ResourceLocation textureId) {
        ResourceLocation existingTile = AntiqueAtlasMod.tileData.getData((RegistryKey<World>)world.func_234923_W_()).getTile(chunkX, chunkZ);
        if (StructureHandler.getPriority(structurePieceId) < StructureHandler.getPriority(existingTile)) {
            AtlasAPI.tiles.putCustomGlobalTile(world, textureId, chunkX, chunkZ);
        }
    }

    public static void resolve(StructurePiece structurePiece, ServerWorld world) {
        ResourceLocation structurePieceId = Registry.field_218362_C.func_177774_c((Object)structurePiece.func_214807_k());
        if (STRUCTURE_PIECE_TO_TILE_MAP.containsKey((Object)structurePieceId)) {
            for (Tuple entry : STRUCTURE_PIECE_TO_TILE_MAP.get((Object)structurePieceId)) {
                Collection<ChunkPos> matches = ((Setter)entry.func_76340_b()).matches(structurePiece.func_74874_b());
                for (ChunkPos pos : matches) {
                    StructureHandler.put(structurePieceId, (World)world, pos.field_77276_a, pos.field_77275_b, (ResourceLocation)entry.func_76341_a());
                }
            }
        }
    }

    public static void resolve(StructureStart<?> structureStart, ServerWorld world) {
        ResourceLocation structureId = Registry.field_218361_B.func_177774_c((Object)structureStart.func_214627_k());
        if (STRUCTURE_PIECE_TO_MARKER_MAP.containsKey(structureId)) {
            AtlasAPI.markers.putGlobalMarker((World)world, false, (MarkerType)MarkerType.REGISTRY.func_82594_a((ResourceLocation)STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId).func_76341_a()), (ITextComponent)STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId).func_76340_b(), structureStart.func_75071_a().func_215126_f().func_177958_n(), structureStart.func_75071_a().func_215126_f().func_177952_p());
        }
    }

    static interface Setter {
        public Collection<ChunkPos> matches(MutableBoundingBox var1);
    }
}

