/*
 * Decompiled with CFR 0.152.
 */
package kenkron.antiqueatlasoverlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.SubTileQuartet;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileRenderIterator;
import hunternif.mc.impl.atlas.client.gui.GuiAtlas;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.registry.MarkerRenderInfo;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.Rect;
import java.util.List;
import kenkron.antiqueatlasoverlay.SetTileRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OverlayRenderer
extends AbstractGui {
    private static final int CHUNK_SIZE = 16;
    private static final float INNER_ELEMENTS_SCALE_FACTOR = 1.9f;
    private Minecraft client;
    private PlayerEntity player;
    private World world;
    private Integer atlasID;

    private Integer getPlayerAtlas(PlayerEntity player) {
        if (!((Boolean)AntiqueAtlasConfig.itemNeeded.get()).booleanValue()) {
            return player.func_110124_au().hashCode();
        }
        ItemStack stack = player.func_184592_cb();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
            return AtlasItem.getAtlasID(stack);
        }
        for (int i = 0; i < 9; ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != RegistrarAntiqueAtlas.ATLAS) continue;
            return AtlasItem.getAtlasID(stack);
        }
        return null;
    }

    public void drawOverlay(MatrixStack matrices) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiAtlas) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        this.client = Minecraft.func_71410_x();
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.world = Minecraft.func_71410_x().field_71441_e;
        if (((Boolean)AntiqueAtlasConfig.requiresHold.get()).booleanValue()) {
            ItemStack stack = this.player.func_184614_ca();
            ItemStack stack2 = this.player.func_184592_cb();
            if (!stack.func_190926_b() && stack.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
                this.atlasID = AtlasItem.getAtlasID(stack);
            } else if (!stack2.func_190926_b() && stack2.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
                this.atlasID = AtlasItem.getAtlasID(stack2);
            }
        } else {
            this.atlasID = this.getPlayerAtlas(this.player);
        }
        if (this.atlasID != null) {
            this.drawMinimap(matrices);
        }
        this.atlasID = null;
    }

    private void drawMinimap(MatrixStack matrices) {
        this.client.func_110434_K().func_110577_a(Textures.BOOK);
        OverlayRenderer.func_238466_a_((MatrixStack)matrices, (int)0, (int)0, (int)465, (int)327, (float)0.0f, (float)0.0f, (int)310, (int)218, (int)310, (int)218);
        matrices.func_227860_a_();
        matrices.func_227860_a_();
        matrices.func_227862_a_(1.9f, 1.9f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        this.drawTiles(matrices);
        if ((Integer)AntiqueAtlasConfig.markerSize.get() > 0) {
            this.drawMarkers(matrices);
        }
        matrices.func_227865_b_();
        this.drawPlayer(matrices);
        matrices.func_227865_b_();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.BOOK_FRAME);
        OverlayRenderer.func_238466_a_((MatrixStack)matrices, (int)0, (int)0, (int)465, (int)327, (float)0.0f, (float)0.0f, (int)310, (int)218, (int)310, (int)218);
        RenderSystem.disableBlend();
    }

    private void drawTiles(MatrixStack matrices) {
        WorldData biomeData = AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, this.world).getWorldData((RegistryKey<World>)this.world.func_234923_W_());
        TileRenderIterator iter = new TileRenderIterator(biomeData);
        Rect iteratorScope = this.getChunkCoverage(this.player.func_213303_ch());
        iter.setScope(iteratorScope);
        iter.setStep(1);
        Vector3d chunkPosition = this.player.func_213303_ch().func_216372_d(0.0625, 0.0625, 0.0625);
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        SetTileRenderer renderer = new SetTileRenderer(matrices, (Integer)AntiqueAtlasConfig.tileSize.get() / 2);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                float relativeChunkPositionX = (float)((double)subtile.x / 2.0 + (double)iteratorScope.minX - chunkPosition.field_72450_a);
                float relativeChunkPositionY = (float)((double)subtile.y / 2.0 + (double)iteratorScope.minY - chunkPosition.field_72449_c);
                renderer.addTileCorner(BiomeTextureMap.instance().getTexture(subtile.variationNumber, subtile.tile), shapeMiddleX + (int)Math.floor(relativeChunkPositionX * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue()), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue()), subtile.getTextureU(), subtile.getTextureV());
            }
        }
        renderer.draw();
    }

    private void drawMarkers(MatrixStack matrices) {
        WorldData biomeData = AntiqueAtlasMod.atlasData.getAtlasData(this.atlasID, this.world).getWorldData((RegistryKey<World>)this.world.func_234923_W_());
        DimensionMarkersData globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInWorld((RegistryKey<World>)this.world.func_234923_W_());
        this.drawMarkersData(matrices, globalMarkersData, biomeData);
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, (World)Minecraft.func_71410_x().field_71441_e);
        DimensionMarkersData localMarkersData = null;
        if (markersData != null) {
            localMarkersData = markersData.getMarkersDataInWorld((RegistryKey<World>)this.world.func_234923_W_());
        }
        this.drawMarkersData(matrices, localMarkersData, biomeData);
    }

    private void drawPlayer(MatrixStack matrices) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Textures.PLAYER);
        matrices.func_227860_a_();
        matrices.func_227861_a_(232.0, 163.0, 0.0);
        matrices.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, this.player.func_70079_am() + 180.0f, true));
        matrices.func_227861_a_((double)(-((Integer)AntiqueAtlasConfig.playerIconWidth.get()).intValue()) / 2.0, (double)(-((Integer)AntiqueAtlasConfig.playerIconHeight.get()).intValue()) / 2.0, 0.0);
        OverlayRenderer.func_238466_a_((MatrixStack)matrices, (int)0, (int)0, (int)((Integer)AntiqueAtlasConfig.playerIconWidth.get()), (int)((Integer)AntiqueAtlasConfig.playerIconHeight.get()), (float)0.0f, (float)0.0f, (int)8, (int)7, (int)8, (int)7);
        matrices.func_227865_b_();
    }

    private void drawMarkersData(MatrixStack matrices, DimensionMarkersData markersData, WorldData biomeData) {
        Rect mcchunks = this.getChunkCoverage(this.player.func_213303_ch());
        Rect chunks = new Rect(mcchunks.minX / 8, mcchunks.minY / 8, (int)Math.ceil((float)mcchunks.maxX / 8.0f), (int)Math.ceil((float)mcchunks.maxY / 8.0f));
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        Vector3d chunkPosition = this.player.func_213303_ch().func_216372_d(0.0625, 0.0625, 0.0625);
        for (int x = chunks.minX; x <= chunks.maxX; ++x) {
            for (int z = chunks.minY; z <= chunks.maxY; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(Math.round(x), Math.round(z));
                if (markers == null) continue;
                for (Marker marker : markers) {
                    float relativeChunkPositionX = (float)((double)marker.getChunkX() - chunkPosition.field_72450_a);
                    float relativeChunkPositionY = (float)((double)marker.getChunkZ() - chunkPosition.field_72449_c);
                    this.renderMarker(matrices, marker, shapeMiddleX + (int)Math.floor(relativeChunkPositionX * 8.0f), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * 8.0f), biomeData);
                }
            }
        }
    }

    private void renderMarker(MatrixStack matrices, Marker marker, int x, int y, WorldData biomeData) {
        int tileHalfSize = 2;
        if (x + tileHalfSize > 240 || x - tileHalfSize < 3 || y + tileHalfSize >= 166 || y - tileHalfSize < 0) {
            return;
        }
        if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        MarkerType type = (MarkerType)MarkerType.REGISTRY.func_82594_a(marker.getType());
        MarkerRenderInfo info = type.getRenderInfo(1.0, ((Integer)AntiqueAtlasConfig.tileSize.get()).intValue(), 1.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(info.tex);
        OverlayRenderer.func_238466_a_((MatrixStack)matrices, (int)(x - 8 + 1), (int)(y - 8 + 4), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
    }

    private Rect getChunkCoverage(Vector3d position) {
        int minChunkX = (int)Math.floor(position.field_72450_a / 16.0 - (double)(310.0f / (4.0f * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue())));
        int minChunkY = (int)Math.floor(position.field_72449_c / 16.0 - (double)(218.0f / (4.0f * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue())));
        int maxChunkX = (int)Math.ceil(position.field_72450_a / 16.0 + (double)(310.0f / (4.0f * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue())));
        int maxChunkY = (int)Math.ceil(position.field_72449_c / 16.0 + (double)(218.0f / (4.0f * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue())));
        return new Rect(minChunkX -= 4, minChunkY -= 3, maxChunkX += 4, maxChunkY += 2);
    }
}

