/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.writer;

import de.siegmar.fastcsv.writer.CsvAppender;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Objects;

public final class CsvWriter {
    private char fieldSeparator = (char)44;
    private char textDelimiter = (char)34;
    private boolean alwaysDelimitText;
    private char[] lineDelimiter = System.lineSeparator().toCharArray();

    public void setFieldSeparator(char fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void setTextDelimiter(char textDelimiter) {
        this.textDelimiter = textDelimiter;
    }

    public void setAlwaysDelimitText(boolean alwaysDelimitText) {
        this.alwaysDelimitText = alwaysDelimitText;
    }

    public void setLineDelimiter(char[] lineDelimiter) {
        this.lineDelimiter = (char[])lineDelimiter.clone();
    }

    public void write(File file, Charset charset, Collection<String[]> data) throws IOException {
        this.write(Objects.requireNonNull(file, "file must not be null").toPath(), Objects.requireNonNull(charset, "charset must not be null"), data);
    }

    public void write(Path path, Charset charset, Collection<String[]> data) throws IOException {
        Objects.requireNonNull(path, "path must not be null");
        Objects.requireNonNull(charset, "charset must not be null");
        try (Writer writer = CsvWriter.newWriter(path, charset);){
            this.write(writer, data);
        }
    }

    public void write(Writer writer, Collection<String[]> data) throws IOException {
        Objects.requireNonNull(data, "data must not be null");
        CsvAppender appender = this.append(writer);
        for (String[] values : data) {
            appender.appendLine(values);
        }
        appender.flush();
    }

    public CsvAppender append(File file, Charset charset) throws IOException {
        return this.append(Objects.requireNonNull(file, "file must not be null").toPath(), Objects.requireNonNull(charset, "charset must not be null"));
    }

    public CsvAppender append(Path path, Charset charset) throws IOException {
        return this.append(CsvWriter.newWriter(Objects.requireNonNull(path, "path must not be null"), Objects.requireNonNull(charset, "charset must not be null")));
    }

    public CsvAppender append(Writer writer) {
        return new CsvAppender(Objects.requireNonNull(writer, "writer must not be null"), this.fieldSeparator, this.textDelimiter, this.alwaysDelimitText, this.lineDelimiter);
    }

    private static Writer newWriter(Path path, Charset charset) throws IOException {
        return new OutputStreamWriter(Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE), charset);
    }
}

