/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;

public class EdChimneyBlock
extends DecorBlock.Cutout
implements IDecorBlock {
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;

    public EdChimneyBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB aabb) {
        super(config, properties, aabb);
    }

    public EdChimneyBlock(long config, AbstractBlock.Properties builder) {
        this(config, builder, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWER});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        if (state == null) {
            return state;
        }
        int p = context.func_195991_k().func_175687_A(context.func_195995_a());
        return (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(p == 0 ? 5 : p));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)POWER) + 1 & 0xF)), 3);
        return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
        int p = world.func_175687_A(pos);
        if (p != (Integer)state.func_177229_b((Property)POWER)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(p)), 2);
        }
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rnd) {
        if (state.func_177230_c() != this) {
            return;
        }
        int p = (Integer)state.func_177229_b((Property)POWER);
        if (p == 0) {
            return;
        }
        int end = 1 + rnd.nextInt(10) * p / 15;
        for (int i = 0; i < end; ++i) {
            double rv = rnd.nextDouble() * (double)p / 5.0;
            world.func_195594_a((IParticleData)(rv > 0.7 ? ParticleTypes.field_197594_E : (rv > 0.4 ? ParticleTypes.field_197601_L : ParticleTypes.field_218417_ae)), 0.5 + (double)pos.func_177958_n() + rnd.nextDouble() * 0.2, 0.9 + (double)pos.func_177956_o() + rnd.nextDouble() * 0.1, 0.5 + (double)pos.func_177952_p() + rnd.nextDouble() * 0.2, -0.02 + rnd.nextDouble() * 0.04, 0.05 + rnd.nextDouble() * 0.1, -0.02 + rnd.nextDouble() * 0.04);
        }
    }
}

