/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class VariantSlabBlock
extends StandardBlocks.WaterLoggable
implements StandardBlocks.IStandardBlock {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.field_208145_at;
    public static final IntegerProperty TEXTURE_VARIANT = IntegerProperty.func_177719_a((String)"tvariant", (int)0, (int)3);
    protected static final VoxelShape[] AABBs = new VoxelShape[]{VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0))};
    protected static final int[] num_slabs_contained_in_parts_ = new int[]{1, 1, 2, 2};
    private static boolean with_pickup = false;

    public static void on_config(boolean direct_slab_pickup) {
        with_pickup = direct_slab_pickup;
    }

    protected boolean is_cube(BlockState state) {
        return state.func_177229_b(TYPE) == SlabType.DOUBLE;
    }

    public VariantSlabBlock(long config, AbstractBlock.Properties builder) {
        super(config, builder);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)SlabType.BOTTOM));
    }

    @Override
    public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
        return (this.config & 4L) != 0L ? StandardBlocks.IStandardBlock.RenderTypeHint.TRANSLUCENT : StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true)) {
            return;
        }
        if (with_pickup) {
            Auxiliaries.Tooltip.addInformation("engineersdecor.tooltip.slabpickup", "engineersdecor.tooltip.slabpickup", tooltip, flag, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState == state ? true : super.func_200122_a(state, adjacentBlockState, side);
    }

    @Override
    public boolean func_181623_g() {
        return false;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
        return AABBs[((SlabType)state.func_177229_b(TYPE)).ordinal() & 3];
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.func_220053_a(state, world, pos, selectionContext);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TYPE, TEXTURE_VARIANT});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        if (context.func_195991_k().func_180495_p(pos).func_177230_c() == this) {
            return (BlockState)((BlockState)context.func_195991_k().func_180495_p(pos).func_206870_a(TYPE, (Comparable)SlabType.DOUBLE)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        int rnd = MathHelper.func_76125_a((int)((int)(MathHelper.func_180186_a((Vector3i)context.func_195995_a()) & 3L)), (int)0, (int)3);
        Direction face = context.func_196000_l();
        BlockState placement_state = (BlockState)super.func_196258_a(context).func_206870_a((Property)TEXTURE_VARIANT, (Comparable)Integer.valueOf(rnd));
        if (face == Direction.UP) {
            return (BlockState)placement_state.func_206870_a(TYPE, (Comparable)SlabType.BOTTOM);
        }
        if (face == Direction.DOWN) {
            return (BlockState)placement_state.func_206870_a(TYPE, (Comparable)SlabType.TOP);
        }
        if (!face.func_176740_k().func_176722_c()) {
            return placement_state;
        }
        boolean isupper = context.func_221532_j().func_82617_b() - (double)context.func_195995_a().func_177956_o() > 0.5;
        return (BlockState)placement_state.func_206870_a(TYPE, (Comparable)(isupper ? SlabType.TOP : SlabType.BOTTOM));
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        boolean isupper;
        if (context.func_195996_i().func_77973_b() != this.func_199767_j()) {
            return false;
        }
        if (!context.func_196012_c()) {
            return true;
        }
        Direction face = context.func_196000_l();
        SlabType type = (SlabType)state.func_177229_b(TYPE);
        if (face == Direction.UP && type == SlabType.BOTTOM) {
            return true;
        }
        if (face == Direction.DOWN && type == SlabType.TOP) {
            return true;
        }
        if (!face.func_176740_k().func_176722_c()) {
            return false;
        }
        boolean bl = isupper = context.func_221532_j().func_82617_b() - (double)context.func_195995_a().func_177956_o() > 0.5;
        return isupper ? type == SlabType.BOTTOM : type == SlabType.TOP;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state;
    }

    @Override
    public boolean hasDynamicDropList() {
        return true;
    }

    @Override
    public List<ItemStack> dropList(BlockState state, World world, TileEntity te, boolean explosion) {
        return new ArrayList<ItemStack>(Collections.singletonList(new ItemStack((IItemProvider)this.func_199767_j(), num_slabs_contained_in_parts_[((SlabType)state.func_177229_b(TYPE)).ordinal() & 3])));
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (world.field_72995_K || !with_pickup) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || Block.func_149634_a((Item)stack.func_77973_b()) != this) {
            return;
        }
        if (stack.func_190916_E() >= stack.func_77976_d()) {
            return;
        }
        Vector3d lv = player.func_70040_Z();
        Direction facing = Direction.func_176737_a((float)((float)lv.field_72450_a), (float)((float)lv.field_72448_b), (float)((float)lv.field_72449_c));
        if (facing != Direction.UP && facing != Direction.DOWN) {
            return;
        }
        if (state.func_177230_c() != this) {
            return;
        }
        SlabType type = (SlabType)state.func_177229_b(TYPE);
        if (facing == Direction.DOWN) {
            if (type == SlabType.DOUBLE) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a(TYPE, (Comparable)SlabType.BOTTOM), 3);
            } else {
                world.func_217377_a(pos, false);
            }
        } else if (facing == Direction.UP) {
            if (type == SlabType.DOUBLE) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a(TYPE, (Comparable)SlabType.TOP), 3);
            } else {
                world.func_217377_a(pos, false);
            }
        }
        if (!player.func_184812_l_()) {
            stack.func_190917_f(1);
            if (player.field_71071_by != null) {
                player.field_71071_by.func_70296_d();
            }
        }
        SoundType st = this.getSoundType(state, (IWorldReader)world, pos, null);
        world.func_184133_a(player, pos, st.func_185841_e(), SoundCategory.BLOCKS, (st.func_185843_a() + 1.0f) / 2.5f, 0.9f * st.func_185847_b());
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, FluidState fluidState) {
        return state.func_177229_b(TYPE) == SlabType.DOUBLE ? false : super.func_204509_a(world, pos, state, fluidState);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return state.func_177229_b(TYPE) == SlabType.DOUBLE ? false : super.func_204510_a(world, pos, state, fluid);
    }
}

