/*
 * Decompiled with CFR 0.152.
 */
package mod.teamdraco.frozenup.client.model;

import java.util.Collections;
import java.util.List;
import mod.teamdraco.frozenup.entity.ChillooEntity;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class ChillooModel<T extends Entity>
extends AgeableModel<ChillooEntity> {
    public ModelRenderer body;
    public ModelRenderer tail;
    public ModelRenderer head;
    public ModelRenderer left_leg;
    public ModelRenderer right_leg;
    public ModelRenderer body_feathers;
    public ModelRenderer tail_feathers;
    public ModelRenderer head_feathers;
    private final List<ModelRenderer> headParts;
    private final List<ModelRenderer> bodyParts;

    public ChillooModel() {
        super(true, 8.0f, 3.0f);
        this.field_78090_t = 112;
        this.field_78089_u = 64;
        this.right_leg = new ModelRenderer((Model)this, 0, 25);
        this.right_leg.func_78793_a(4.5f, 1.0f, 7.5f);
        this.right_leg.func_228302_a_(-3.0f, 0.0f, -2.5f, 5.0f, 11.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.head_feathers = new ModelRenderer((Model)this, 0, 55);
        this.head_feathers.func_78793_a(0.0f, 6.0f, 0.0f);
        this.head_feathers.func_228302_a_(-3.0f, 0.0f, -5.5f, 6.0f, 2.0f, 7.0f, 0.0f, 0.0f, 0.0f);
        this.head = new ModelRenderer((Model)this, 36, 0);
        this.head.func_78793_a(0.0f, 12.0f, -10.0f);
        this.head.func_228302_a_(-4.0f, 0.0f, -7.0f, 8.0f, 6.0f, 9.0f, 0.0f, 0.0f, 0.0f);
        this.tail_feathers = new ModelRenderer((Model)this, 60, 42);
        this.tail_feathers.func_78793_a(0.0f, 0.0f, 0.0f);
        this.tail_feathers.func_228302_a_(-1.5f, 3.0f, 0.0f, 3.0f, 4.0f, 18.0f, 0.0f, 0.0f, 0.0f);
        this.body_feathers = new ModelRenderer((Model)this, 4, 25);
        this.body_feathers.func_78793_a(0.0f, 0.0f, 0.0f);
        this.body_feathers.func_228302_a_(-5.0f, 6.0f, 0.0f, 10.0f, 3.0f, 16.0f, 0.0f, 0.0f, 0.0f);
        this.body = new ModelRenderer((Model)this, 0, 0);
        this.body.func_78793_a(0.0f, 12.0f, -8.0f);
        this.body.func_228302_a_(-5.0f, -3.0f, 0.0f, 10.0f, 9.0f, 16.0f, 0.0f, 0.0f, 0.0f);
        this.tail = new ModelRenderer((Model)this, 52, 0);
        this.tail.func_78793_a(0.0f, 0.0f, 14.0f);
        this.tail.func_228302_a_(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 18.0f, 0.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.tail, -0.5235988f, 0.0f, 0.0f);
        this.left_leg = new ModelRenderer((Model)this, 0, 25);
        this.left_leg.field_78809_i = true;
        this.left_leg.func_78793_a(-4.5f, 1.0f, 7.5f);
        this.left_leg.func_228302_a_(-2.0f, 0.0f, -2.5f, 5.0f, 11.0f, 5.0f, 0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(this.right_leg);
        this.head.func_78792_a(this.head_feathers);
        this.tail.func_78792_a(this.tail_feathers);
        this.body.func_78792_a(this.body_feathers);
        this.body.func_78792_a(this.tail);
        this.body.func_78792_a(this.left_leg);
        this.headParts = Collections.singletonList(this.head);
        this.bodyParts = Collections.singletonList(this.body);
    }

    public void setLivingAnimations(ChillooEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        float speed = 1.0f;
        float degree = 1.0f;
        if (entityIn.func_233684_eK_()) {
            if (entityIn.func_70631_g_()) {
                this.head.field_78797_d = 9.0f;
                this.head.field_78798_e = -5.0f;
            } else {
                this.head.field_78797_d = 5.5f;
                this.head.field_78798_e = -4.5f;
            }
            this.body.func_78793_a(0.0f, 9.0f, -2.0f);
            this.setRotateAngle(this.body, -1.0471976f, 0.0f, 0.0f);
            this.tail.func_78793_a(0.0f, 0.0f, 14.0f);
            this.setRotateAngle(this.tail, 1.7453293f, 0.0f, 0.0f);
            this.left_leg.func_78793_a(-4.5f, 4.0f, 12.0f);
            this.setRotateAngle(this.left_leg, -0.4712389f, 0.17453292f, 0.2617994f);
            this.right_leg.func_78793_a(4.5f, 4.0f, 12.0f);
            this.setRotateAngle(this.right_leg, -0.4712389f, -0.17453292f, -0.2617994f);
        } else {
            this.head.field_78808_h = MathHelper.func_76134_b((float)(limbSwing * speed * 0.4f)) * degree * 0.2f * limbSwingAmount;
            this.head.field_78797_d = 12.0f;
            this.head.field_78798_e = -10.0f;
            this.tail.field_78796_g = MathHelper.func_76134_b((float)(limbSwing * speed * 0.2f)) * degree * 0.6f * limbSwingAmount;
            this.tail.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * speed * 0.4f)) * degree * 0.6f * limbSwingAmount - 0.4f;
            this.tail.field_78798_e = 14.0f;
            this.right_leg.field_78795_f = MathHelper.func_76134_b((float)(1.0f + limbSwing * speed * 0.4f)) * degree * 0.8f * limbSwingAmount;
            this.right_leg.field_78796_g = 0.0f;
            this.right_leg.field_78808_h = 0.0f;
            this.right_leg.field_78800_c = 4.5f;
            this.right_leg.field_78797_d = 1.0f;
            this.right_leg.field_78798_e = 7.5f;
            this.left_leg.field_78795_f = MathHelper.func_76134_b((float)(1.0f + limbSwing * speed * 0.4f)) * degree * -0.8f * limbSwingAmount;
            this.left_leg.field_78796_g = 0.0f;
            this.left_leg.field_78808_h = 0.0f;
            this.left_leg.field_78800_c = -4.5f;
            this.left_leg.field_78797_d = 1.0f;
            this.left_leg.field_78798_e = 7.5f;
            this.body.func_78793_a(0.0f, 12.0f, -8.0f);
            this.body.field_78795_f = 0.0f;
            this.body.field_78808_h = MathHelper.func_76134_b((float)(limbSwing * speed * 0.4f)) * degree * 0.1f * limbSwingAmount;
        }
        int timer = entityIn.digTimer;
        if (!entityIn.func_233684_eK_() && timer > 0) {
            this.head.field_78797_d = ChillooModel.getHeadRotationPointY(timer, partialTick);
            this.head.field_78795_f = ChillooModel.getHeadRotationAngleX(timer, partialTick);
        }
    }

    public void setRotationAngles(ChillooEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityIn.digTimer <= 0) {
            this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
            this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        }
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return this.headParts;
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return this.bodyParts;
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    private static float getHeadRotationPointY(int timer, float partialTicks) {
        if (timer >= 3 && timer <= 36) {
            return 14.0f;
        }
        return timer < 4 ? (float)timer - partialTicks + 12.0f : -((float)(timer - 40) - partialTicks) * 0.5f + 12.0f;
    }

    private static float getHeadRotationAngleX(int timer, float partialTicks) {
        if (timer >= 3 && timer <= 36) {
            float f = ((float)(timer - 4) - partialTicks) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return timer > 0 ? 0.62831855f : 0.0f;
    }
}

