/*
 * Decompiled with CFR 0.152.
 */
package mod.teamdraco.frozenup.client.renderer;

import java.util.function.Function;
import mod.teamdraco.frozenup.client.model.ChillooModel;
import mod.teamdraco.frozenup.entity.ChillooEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChillooRenderer
extends MobRenderer<ChillooEntity, ChillooModel<ChillooEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("frozenup", "textures/entity/chilloo.png");
    private static final ResourceLocation[] COLOR_TEXTURES = new ResourceLocation[32];

    public ChillooRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new ChillooModel(), 0.5f);
    }

    public ResourceLocation getEntityTexture(ChillooEntity entity) {
        DyeColor bandColor = entity.getBandColor();
        if (bandColor == null) {
            DyeColor sweaterColor = entity.getSweaterColor();
            if (sweaterColor == null) {
                return TEXTURE;
            }
            return this.getTexture(sweaterColor.ordinal() + 16, color -> new ResourceLocation("frozenup", "textures/entity/sweaters/" + color.func_176762_d() + ".png"));
        }
        return this.getTexture(bandColor.ordinal(), color -> new ResourceLocation("frozenup", "textures/entity/bands/" + color.func_176762_d() + ".png"));
    }

    private ResourceLocation getTexture(int color, Function<DyeColor, ResourceLocation> colorSupplier) {
        ResourceLocation colorTexture = COLOR_TEXTURES[color];
        if (colorTexture == null) {
            ChillooRenderer.COLOR_TEXTURES[color] = colorTexture = colorSupplier.apply(DyeColor.func_196056_a((int)(color % 16)));
        }
        return colorTexture;
    }
}

