/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerModList;
import com.blamejared.crafttweaker.api.annotations.Preprocessor;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.RecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.brackets.ValidatedEscapableBracketParser;
import com.blamejared.crafttweaker.api.zencode.impl.registry.BracketResolverRegistry;
import com.blamejared.crafttweaker.api.zencode.impl.registry.PreprocessorRegistry;
import com.blamejared.crafttweaker.api.zencode.impl.registry.ZenClassRegistry;
import com.blamejared.crafttweaker.impl.commands.BracketDumperInfo;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.blamejared.crafttweaker.impl.tag.registry.CrTTagRegistryData;
import com.google.common.collect.BiMap;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import org.openzen.zencode.java.ScriptingEngine;
import org.openzen.zencode.java.module.JavaNativeModule;

public class CraftTweakerRegistry {
    private static final BracketResolverRegistry BRACKET_RESOLVER_REGISTRY = new BracketResolverRegistry();
    private static final PreprocessorRegistry PREPROCESSOR_REGISTRY = new PreprocessorRegistry();
    private static final RecipeHandlerRegistry RECIPE_HANDLER_REGISTRY = new RecipeHandlerRegistry();
    private static final ZenClassRegistry ZEN_CLASS_REGISTRY = new ZenClassRegistry();

    public static void findClasses() {
        CraftTweakerModList craftTweakerModList = new CraftTweakerModList();
        List<Class> collect = CraftTweakerRegistry.getAllClassesWith(ZenRegister.class, craftTweakerModList::add).filter(Objects::nonNull).collect(Collectors.toList());
        craftTweakerModList.printToLog();
        collect.forEach(ZEN_CLASS_REGISTRY::addNativeType);
        ZEN_CLASS_REGISTRY.initNativeTypes();
        collect.forEach(ZEN_CLASS_REGISTRY::addClass);
        BRACKET_RESOLVER_REGISTRY.addClasses(ZEN_CLASS_REGISTRY.getAllRegisteredClasses());
        BRACKET_RESOLVER_REGISTRY.validateBrackets();
        CraftTweakerRegistry.getAllClassesWith(Preprocessor.class).forEach(PREPROCESSOR_REGISTRY::addClass);
        ZEN_CLASS_REGISTRY.getImplementationsOf(TagManager.class).forEach(CrTTagRegistryData.INSTANCE::addTagImplementationClass);
        CraftTweakerRegistry.getAllClassesWith(IRecipeHandler.For.class).distinct().forEach(RECIPE_HANDLER_REGISTRY::addClass);
    }

    private static Class<?> getClassFromType(Type type) {
        try {
            return Class.forName(type.getClassName(), false, CraftTweaker.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Stream<? extends Class<?>> getAllClassesWith(Class<? extends Annotation> annotationCls) {
        return CraftTweakerRegistry.getAllClassesWith(annotationCls, ignored -> {});
    }

    private static Stream<? extends Class<?>> getAllClassesWith(Class<? extends Annotation> annotationCls, Consumer<ModFileScanData> consumer) {
        Type annotationType = Type.getType(annotationCls);
        return ModList.get().getAllScanData().stream().flatMap(scanData -> scanData.getAnnotations().stream().filter(a -> annotationType.equals((Object)a.getAnnotationType())).peek(ignored -> consumer.accept((ModFileScanData)scanData)).map(ModFileScanData.AnnotationData::getClassType)).map(CraftTweakerRegistry::getClassFromType).filter(Objects::nonNull);
    }

    public static ZenClassRegistry getZenClassRegistry() {
        return ZEN_CLASS_REGISTRY;
    }

    public static BiMap<String, Class<?>> getZenClassMap() {
        return ZEN_CLASS_REGISTRY.getZenClasses();
    }

    public static List<Class<?>> getClassesInPackage(String name) {
        return ZEN_CLASS_REGISTRY.getClassesInPackage(name);
    }

    public static Set<String> getRootPackages() {
        return ZEN_CLASS_REGISTRY.getRootPackages();
    }

    public static BiMap<String, Class<?>> getZenGlobals() {
        return ZEN_CLASS_REGISTRY.getZenGlobals();
    }

    public static List<Class<?>> getGlobalsInPackage(String name) {
        return ZEN_CLASS_REGISTRY.getGlobalsInPackage(name);
    }

    public static Map<String, List<Class<?>>> getExpansions() {
        return ZEN_CLASS_REGISTRY.getExpansionsByExpandedName();
    }

    public static Optional<String> tryGetZenClassNameFor(Class<?> cls) {
        return ZEN_CLASS_REGISTRY.tryGetNameFor(cls);
    }

    public static List<Class<? extends IRecipeManager>> getRecipeManagers() {
        return ZEN_CLASS_REGISTRY.getRecipeManagers();
    }

    public static Map<String, BracketDumperInfo> getBracketDumpers() {
        return BRACKET_RESOLVER_REGISTRY.getBracketDumpers();
    }

    public static void addAdvancedBEPName(String name) {
        BRACKET_RESOLVER_REGISTRY.addAdvancedBEPName(name);
    }

    public static List<ValidatedEscapableBracketParser> getBracketResolvers(String name, ScriptingEngine scriptingEngine, JavaNativeModule crafttweakerModule) {
        return BRACKET_RESOLVER_REGISTRY.getBracketResolvers(name, scriptingEngine, crafttweakerModule);
    }

    public static List<IPreprocessor> getPreprocessors() {
        return PREPROCESSOR_REGISTRY.getPreprocessors();
    }

    public static <T extends IRecipe<?>> IRecipeHandler<T> getHandlerFor(T recipe) {
        return RECIPE_HANDLER_REGISTRY.getHandlerFor(recipe);
    }
}

