/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.logger;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.logger.LogLevel;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.java.logger.ScriptingEngineLogger;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.validator.ValidationLogEntry;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.ILogger")
@Document(value="vanilla/api/logger/ILogger")
public interface ILogger
extends ScriptingEngineLogger {
    public void setLogLevel(LogLevel var1);

    public LogLevel getLogLevel();

    public void log(LogLevel var1, String var2, boolean var3);

    default public void log(LogLevel level, String message) {
        this.log(level, message, true);
    }

    @Override
    @ZenCodeType.Method
    default public void info(String message) {
        this.log(LogLevel.INFO, message);
    }

    @Override
    @ZenCodeType.Method
    default public void debug(String message) {
        this.log(LogLevel.DEBUG, message);
    }

    @Override
    @ZenCodeType.Method
    default public void warning(String message) {
        this.log(LogLevel.WARNING, message);
    }

    @Override
    @ZenCodeType.Method
    default public void error(String message) {
        this.log(LogLevel.ERROR, message);
    }

    @Override
    @ZenCodeType.Method
    default public void trace(String message) {
        this.log(LogLevel.TRACE, message);
    }

    @Override
    default public void throwingErr(String message, Throwable throwable) {
        this.error(message);
        StringPrintStream errorStream = new StringPrintStream();
        throwable.printStackTrace(errorStream);
        this.log(LogLevel.ERROR, errorStream.getValue(), false);
    }

    @Override
    default public void throwingWarn(String message, Throwable throwable) {
        this.warning(message);
        StringPrintStream errorStream = new StringPrintStream();
        throwable.printStackTrace(errorStream);
        this.log(LogLevel.WARNING, errorStream.getValue(), false);
    }

    @Override
    default public void logCompileException(CompileException exception) {
        this.error(exception.getMessage());
    }

    @Override
    default public void logSourceFile(SourceFile file) {
        this.info("Loading file: " + file.getFilename());
    }

    @Override
    default public void logValidationError(ValidationLogEntry errorEntry) {
        this.error(errorEntry.position + " " + errorEntry.message);
    }

    @Override
    default public void logValidationWarning(ValidationLogEntry warningEntry) {
        this.error(warningEntry.position + " " + warningEntry.message);
    }

    public static class StringPrintStream
    extends PrintStream {
        public StringPrintStream() {
            super(new ByteArrayOutputStream());
        }

        public String getValue() {
            return this.out.toString();
        }
    }
}

