/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.managers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.zencode.impl.util.PositionUtil;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveAll;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByModid;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByName;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByOutput;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByRegex;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.managers.CTCraftingTableManager;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import com.blamejared.crafttweaker.impl.util.NameUtils;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.registries.IRecipeManager")
@Document(value="vanilla/api/managers/IRecipeManager")
public interface IRecipeManager
extends CommandStringDisplayable {
    public static final Gson JSON_RECIPE_GSON = new GsonBuilder().create();

    @ZenCodeType.Method
    default public void addJSONRecipe(String name, IData data) {
        name = this.validateRecipeName(name);
        if (!(data instanceof MapData)) {
            throw new IllegalArgumentException("Json recipe's IData should be a MapData!");
        }
        MapData mapData = (MapData)data;
        JsonObject recipeObject = (JsonObject)JSON_RECIPE_GSON.fromJson(mapData.toJsonString(), JsonObject.class);
        ResourceLocation recipeTypeKey = this.getBracketResourceLocation();
        if (recipeObject.has("type")) {
            ResourceLocation recipeSerializerKey;
            try {
                recipeSerializerKey = new ResourceLocation(recipeObject.get("type").getAsString());
            }
            catch (ClassCastException | IllegalStateException | ResourceLocationException ex) {
                throw new IllegalArgumentException("Expected \"type\" field to be a valid resource location.", ex);
            }
            if (!ForgeRegistries.RECIPE_SERIALIZERS.containsKey(recipeSerializerKey)) {
                throw new IllegalArgumentException("Recipe Serializer \"" + recipeSerializerKey + "\" does not exist.");
            }
        } else if (ForgeRegistries.RECIPE_SERIALIZERS.containsKey(recipeTypeKey)) {
            recipeObject.addProperty("type", recipeTypeKey.toString());
        } else {
            throw new IllegalArgumentException("Recipe Type \"" + recipeTypeKey + "\" does not have a Recipe Serializer of the same ID. Please specify a serializer manually using the \"type\" field in the JSON object.");
        }
        IRecipe iRecipe = RecipeManager.func_215377_a((ResourceLocation)new ResourceLocation("crafttweaker", name), (JsonObject)recipeObject);
        IRecipeType recipeType = iRecipe.func_222127_g();
        if (recipeType != this.getRecipeType()) {
            throw new IllegalArgumentException("Recipe Serializer \"" + iRecipe.func_199559_b().getRegistryName() + "\" resulted in Recipe Type \"" + Registry.field_218367_H.func_177774_c((Object)recipeType) + "\" but expected Recipe Type \"" + recipeTypeKey + "\".");
        }
        CraftTweakerAPI.apply(new ActionAddRecipe(this, iRecipe, ""));
    }

    @ZenCodeType.Method
    default public WrapperRecipe getRecipeByName(String name) {
        IRecipe<?> recipe = this.getRecipes().get(new ResourceLocation(name));
        if (recipe == null) {
            throw new IllegalArgumentException("No recipe found with name: \"" + name + "\" in type: \"" + this.getRecipeType().toString() + "\"");
        }
        return new WrapperRecipe(recipe);
    }

    @ZenCodeType.Method
    default public List<WrapperRecipe> getRecipesByOutput(IIngredient output) {
        return this.getRecipes().values().stream().filter(iRecipe -> output.matches(new MCItemStackMutable(iRecipe.func_77571_b()))).map(WrapperRecipe::new).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allRecipes")
    default public List<WrapperRecipe> getAllRecipes() {
        return this.getRecipes().values().stream().map(WrapperRecipe::new).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="recipeMap")
    default public Map<ResourceLocation, WrapperRecipe> getRecipeMap() {
        return this.getRecipes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new WrapperRecipe((IRecipe)entry.getValue())));
    }

    @ZenCodeType.Method
    default public void removeRecipe(IIngredient output) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByOutput(this, output));
    }

    @ZenCodeType.Method
    default public void removeRecipe(IItemStack output) {
        this.removeRecipe((IIngredient)output);
    }

    @ZenCodeType.Method
    default public void removeRecipeByInput(IItemStack input) {
        CraftTweakerAPI.apply(new ActionRemoveRecipe(this, iRecipe -> iRecipe.func_192400_c().stream().anyMatch(ingredient -> ingredient.test(input.getInternal()))));
    }

    @ZenCodeType.Method
    default public void removeByName(String name) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByName(this, new ResourceLocation(name)));
    }

    @ZenCodeType.Method
    default public void removeByModid(String modid) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByModid(this, modid));
    }

    @ZenCodeType.Method
    default public void removeByModid(String modid, RecipeFilter exclude) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByModid(this, modid, exclude));
    }

    @ZenCodeType.Method
    default public void removeByRegex(String regex) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByRegex(this, regex));
    }

    @ZenCodeType.Method
    default public void removeAll() {
        CraftTweakerAPI.apply(new ActionRemoveAll(this));
    }

    public IRecipeType getRecipeType();

    default public Map<ResourceLocation, IRecipe<?>> getRecipes() {
        return CTCraftingTableManager.recipeManager.field_199522_d.computeIfAbsent(this.getRecipeType(), iRecipeType -> new HashMap());
    }

    default public String validateRecipeName(String name) {
        return this.fixRecipeName(name);
    }

    default public String fixRecipeName(String name) {
        CodePosition position = PositionUtil.getZCScriptPositionFromStackTrace();
        return NameUtils.fixing(name, (fixed, mistakes) -> CraftTweakerAPI.logWarning("%sInvalid recipe name '%s', mistakes:\n%s\nNew recipe name: %s", position == CodePosition.UNKNOWN ? "" : position + ": ", name, String.join((CharSequence)"\n", mistakes), fixed));
    }

    default public ResourceLocation getBracketResourceLocation() {
        return Registry.field_218367_H.func_177774_c((Object)this.getRecipeType());
    }

    @Override
    default public String getCommandString() {
        return "<recipetype:" + this.getBracketResourceLocation() + ">";
    }

    @FunctionalInterface
    @ZenRegister
    @ZenCodeType.Name(value="crafttweaker.api.recipe.RecipeFunctionMatrix")
    @Document(value="vanilla/api/recipe/RecipeFunctionMatrix")
    public static interface RecipeFunctionMatrix {
        @ZenCodeType.Method
        public IItemStack process(IItemStack var1, IItemStack[][] var2);
    }

    @FunctionalInterface
    @ZenRegister
    @ZenCodeType.Name(value="crafttweaker.api.recipe.RecipeFunctionArray")
    @Document(value="vanilla/api/recipe/RecipeFunctionArray")
    public static interface RecipeFunctionArray {
        @ZenCodeType.Method
        public IItemStack process(IItemStack var1, IItemStack[] var2);
    }

    @FunctionalInterface
    @ZenRegister
    @ZenCodeType.Name(value="crafttweaker.api.recipe.RecipeFunctionSingle")
    @Document(value="vanilla/api/recipe/RecipeFunctionSingle")
    public static interface RecipeFunctionSingle {
        @ZenCodeType.Method
        public IItemStack process(IItemStack var1, IItemStack var2);
    }

    @FunctionalInterface
    @ZenRegister
    @ZenCodeType.Name(value="crafttweaker.api.recipe.RecipeFilter")
    @Document(value="vanilla/api/recipe/RecipeFilter")
    public static interface RecipeFilter {
        @ZenCodeType.Method
        public boolean test(String var1);
    }
}

