/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.PreprocessorMatch;
import com.blamejared.crafttweaker.api.zencode.impl.SourceFilePreprocessed;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.openzen.zencode.shared.SourceFile;

public class FileAccessSingle {
    private final String fileName;
    private final Map<IPreprocessor, List<PreprocessorMatch>> matches = new HashMap<IPreprocessor, List<PreprocessorMatch>>();
    private final List<String> fileContents;
    private final Map<String, IPreprocessor> registeredPreprocessors;
    private final ScriptLoadingOptions scriptLoadingOptions;
    private boolean shouldBeLoaded;

    public FileAccessSingle(File file, ScriptLoadingOptions scriptLoadingOptions, Collection<IPreprocessor> preprocessors) {
        this.scriptLoadingOptions = scriptLoadingOptions;
        this.registeredPreprocessors = new HashMap<String, IPreprocessor>();
        for (IPreprocessor preprocessor : preprocessors) {
            this.registeredPreprocessors.put(preprocessor.getName().toLowerCase(Locale.ENGLISH), preprocessor);
        }
        this.fileName = file.getName();
        this.fileContents = new ArrayList<String>();
        try {
            this.readFile(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.fillInMissingPreprocessors();
        this.applyPreprocessors();
    }

    public FileAccessSingle(File baseDirectory, File file, ScriptLoadingOptions scriptLoadingOptions, Collection<IPreprocessor> preprocessors) {
        this.scriptLoadingOptions = scriptLoadingOptions;
        if (!file.getAbsolutePath().startsWith(baseDirectory.getAbsolutePath())) {
            throw new IllegalArgumentException("Base directory is not parent of script file!");
        }
        this.registeredPreprocessors = new HashMap<String, IPreprocessor>();
        for (IPreprocessor preprocessor : preprocessors) {
            this.registeredPreprocessors.put(preprocessor.getName().toLowerCase(Locale.ENGLISH), preprocessor);
        }
        this.fileName = file.getAbsolutePath().substring(baseDirectory.getAbsolutePath().length() + 1);
        this.fileContents = new ArrayList<String>();
        try {
            this.readFile(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.fillInMissingPreprocessors();
        this.applyPreprocessors();
    }

    public FileAccessSingle(String fileName, Reader reader, ScriptLoadingOptions scriptLoadingOptions, Collection<IPreprocessor> preprocessors) {
        this.scriptLoadingOptions = scriptLoadingOptions;
        this.registeredPreprocessors = new HashMap<String, IPreprocessor>();
        for (IPreprocessor preprocessor : preprocessors) {
            this.registeredPreprocessors.put(preprocessor.getName().toLowerCase(Locale.ENGLISH), preprocessor);
        }
        this.fileName = fileName;
        this.fileContents = new ArrayList<String>();
        this.readFile(reader);
        this.fillInMissingPreprocessors();
        this.applyPreprocessors();
    }

    public static Comparator<FileAccessSingle> createComparator(Collection<IPreprocessor> preprocessors) {
        ArrayList<IPreprocessor> list = new ArrayList<IPreprocessor>(preprocessors);
        list.sort(Comparator.comparingInt(IPreprocessor::getPriority).reversed());
        Comparator out = null;
        for (IPreprocessor pp : list) {
            out = out == null ? pp : out.thenComparing(pp);
        }
        return out == null ? Comparator.comparing(FileAccessSingle::getFileName) : out.thenComparing(FileAccessSingle::getFileName);
    }

    private void fillInMissingPreprocessors() {
        this.registeredPreprocessors.forEach((key, prep) -> {
            String defaultValue = prep.getDefaultValue();
            if (defaultValue != null && !this.matches.containsKey(prep)) {
                this.matches.put((IPreprocessor)prep, Collections.singletonList(new PreprocessorMatch((IPreprocessor)prep, -1, defaultValue)));
            }
        });
    }

    private void applyPreprocessors() {
        ArrayList<Map.Entry<IPreprocessor, List<PreprocessorMatch>>> entries = new ArrayList<Map.Entry<IPreprocessor, List<PreprocessorMatch>>>(this.matches.entrySet());
        entries.sort(Comparator.comparingInt(e -> ((IPreprocessor)e.getKey()).getPriority()).reversed());
        for (Map.Entry<IPreprocessor, List<PreprocessorMatch>> entry : entries) {
            this.shouldBeLoaded = entry.getKey().apply(this, this.scriptLoadingOptions, entry.getValue());
            if (this.shouldBeLoaded) continue;
            return;
        }
    }

    private void readFile(Reader reader) {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            int i = 0;
            if (bufferedReader.ready()) {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    this.checkPreprocessor(line, ++i);
                    this.fileContents.add(line);
                }
            }
        }
        catch (IOException e) {
            CraftTweakerAPI.logThrowing("Could not load file %s", e, this.fileName);
        }
    }

    private void checkPreprocessor(String line, int lineNumber) {
        Matcher matcher = IPreprocessor.preprocessorPattern.matcher(line);
        if (!matcher.find()) {
            return;
        }
        String g = matcher.group();
        String preprocessorName = g.substring(1).trim().toLowerCase(Locale.ENGLISH);
        if (!this.registeredPreprocessors.containsKey(preprocessorName)) {
            return;
        }
        IPreprocessor preprocessor = this.registeredPreprocessors.get(preprocessorName);
        List matches = this.matches.computeIfAbsent(preprocessor, p -> new ArrayList(1));
        matches.add(new PreprocessorMatch(preprocessor, lineNumber, line.substring(matcher.end())));
    }

    public Map<IPreprocessor, List<PreprocessorMatch>> getMatches() {
        return this.matches;
    }

    public List<PreprocessorMatch> getMatchesFor(IPreprocessor preprocessor) {
        return this.matches.get(preprocessor);
    }

    public boolean hasMatchFor(IPreprocessor preprocessor) {
        return this.matches.containsKey(preprocessor);
    }

    public List<String> getFileContents() {
        return this.fileContents;
    }

    public SourceFile getSourceFile() {
        return new SourceFilePreprocessed(this.fileName, this.fileContents);
    }

    public boolean shouldBeLoaded() {
        return this.shouldBeLoaded;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ScriptLoadingOptions getScriptLoadingOptions() {
        return this.scriptLoadingOptions;
    }
}

