/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.loaders;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class LoaderActions {
    private static final Map<String, LoaderActions> allActionsByLoaderName = new HashMap<String, LoaderActions>();
    private final String loaderName;
    private final List<IAction> actionListServer = new ArrayList<IAction>();
    private final List<IAction> actionListClient = new ArrayList<IAction>();
    private final List<IAction> actionListInvalidClient = new ArrayList<IAction>();
    private final List<IAction> actionListInvalidServer = new ArrayList<IAction>();
    private int runCountClient = 0;
    private int runCountServer = 0;

    private LoaderActions(String loaderName) {
        this.loaderName = loaderName;
    }

    public static LoaderActions getActionForLoader(String loaderName) {
        return allActionsByLoaderName.computeIfAbsent(loaderName, LoaderActions::new);
    }

    public static Set<String> getKnownLoaderNames() {
        return ImmutableSet.copyOf(allActionsByLoaderName.keySet());
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public List<IAction> getActionList() {
        return this.isServer() ? this.actionListServer : this.actionListClient;
    }

    public List<IAction> getActionListInvalid() {
        return this.isServer() ? this.actionListInvalidServer : this.actionListInvalidClient;
    }

    private boolean isServer() {
        return EffectiveSide.get().isServer() || CraftTweaker.serverOverride;
    }

    public void addValidAction(IAction action) {
        this.getActionList().add(action);
    }

    public void addInvalidAction(IAction action) {
        this.getActionListInvalid().add(action);
    }

    public void reload() {
        List<IAction> actionList = this.getActionList();
        actionList.stream().filter(iAction -> iAction instanceof IUndoableAction).filter(iAction -> iAction.shouldApplyOn(EffectiveSide.get())).map(iAction -> (IUndoableAction)iAction).forEach(iUndoableAction -> {
            CraftTweakerAPI.logInfo(iUndoableAction.describeUndo(), new Object[0]);
            iUndoableAction.undo();
        });
        actionList.clear();
        this.getActionListInvalid().clear();
    }

    public boolean isFirstRun() {
        return this.getRunCount() == 0;
    }

    public int getRunCount() {
        return this.isServer() ? this.runCountClient : this.runCountServer;
    }

    public void incrementRunCount() {
        if (this.isServer()) {
            ++this.runCountClient;
        } else {
            ++this.runCountServer;
        }
    }
}

