/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.preprocessors.snipping;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.api.annotations.Preprocessor;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.PreprocessorMatch;
import com.blamejared.crafttweaker.api.zencode.impl.FileAccessSingle;
import com.blamejared.crafttweaker.api.zencode.impl.preprocessors.snipping.SnippingMatch;
import com.blamejared.crafttweaker.api.zencode.impl.preprocessors.snipping.SnippingParameter;
import com.blamejared.crafttweaker.api.zencode.impl.preprocessors.snipping.SnippingParameterHit;
import com.blamejared.crafttweaker.api.zencode.impl.preprocessors.snipping.parameters.SnippingParameterModLoaded;
import com.blamejared.crafttweaker.api.zencode.impl.preprocessors.snipping.parameters.SnippingParameterModNotLoaded;
import com.blamejared.crafttweaker.api.zencode.impl.preprocessors.snipping.parameters.SnippingParameterStart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openzen.zencode.shared.CodePosition;

@Preprocessor
public final class SnippingPreprocessor
implements IPreprocessor {
    public static final String NAME = "snip";
    private final Map<String, SnippingParameter> knownParameters = new HashMap<String, SnippingParameter>();
    private SnippingMatch currentMatch;

    public SnippingPreprocessor() {
        this.addSnippingParameter(new SnippingParameterStart());
        this.addSnippingParameter(new SnippingParameterModLoaded());
        this.addSnippingParameter(new SnippingParameterModNotLoaded());
    }

    public void addSnippingParameter(SnippingParameter parameter) {
        this.knownParameters.put(parameter.getName().toLowerCase(), parameter);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @Override
    public boolean apply(@Nonnull FileAccessSingle file, ScriptLoadingOptions scriptLoadingOptions, @Nonnull List<PreprocessorMatch> preprocessorMatches) {
        ArrayList<SnippingMatch> matches = new ArrayList<SnippingMatch>();
        this.readSnippingMatches(file, preprocessorMatches, matches);
        this.snipIt(file, matches);
        return true;
    }

    private void snipIt(FileAccessSingle file, List<SnippingMatch> matches) {
        for (SnippingMatch match : matches) {
            match.snip(file);
        }
    }

    private void readSnippingMatches(@Nonnull FileAccessSingle file, @Nonnull List<PreprocessorMatch> preprocessorMatches, List<SnippingMatch> matches) {
        this.currentMatch = null;
        for (PreprocessorMatch preprocessorMatch : preprocessorMatches) {
            this.getSnippingMatch(file, matches, preprocessorMatch);
        }
        if (this.currentMatch != null) {
            CodePosition start = this.currentMatch.getStart();
            String name = this.currentMatch.getName();
            CraftTweakerAPI.logWarning("%s Snip '%s' starting at line %d:%d was not closed properly", file, name, start.fromLine, start.fromLineOffset);
        }
    }

    private void getSnippingMatch(@Nonnull FileAccessSingle file, List<SnippingMatch> matches, PreprocessorMatch preprocessorMatch) {
        int line = preprocessorMatch.getLine();
        String fileName = file.getFileName();
        String[] content = preprocessorMatch.getContent().split(" ");
        if (content.length < 1) {
            CraftTweakerAPI.logWarning("%s:%d Using 'snip' requires a parameter, like start, end, modloaded, etc", fileName, line);
            return;
        }
        String snippingParameterName = content[0];
        if (snippingParameterName.toLowerCase().equals("end")) {
            if (this.currentMatch != null) {
                this.currentMatch.setEnd(this.getPosition(file, line, content, 1));
                matches.add(this.currentMatch);
                this.currentMatch = this.currentMatch.getParent();
            } else {
                CraftTweakerAPI.logWarning("%s:%d Called 'snip end' without prior start", fileName, line);
            }
            return;
        }
        if (!this.knownParameters.containsKey(snippingParameterName.toLowerCase())) {
            CraftTweakerAPI.logWarning("%s:%d Unknown 'snip' parameter: '%s'", fileName, line, snippingParameterName);
            return;
        }
        Object[] additionalArguments = Arrays.copyOfRange(content, 1, content.length);
        SnippingParameter snippingParameter = this.knownParameters.get(snippingParameterName.toLowerCase());
        SnippingParameterHit hit = snippingParameter.isHit((String[])additionalArguments);
        if (!hit.validArguments) {
            String array = Arrays.toString(additionalArguments);
            CraftTweakerAPI.logWarning("%s:%d Invalid 'snip' arguments for parameter '%s': %s'", fileName, line, snippingParameterName, array);
            return;
        }
        CodePosition startPosition = this.getPosition(file, line, content, hit.numberOfConsumedArguments + 1);
        this.currentMatch = new SnippingMatch(startPosition, snippingParameterName, this.currentMatch, hit);
        this.checkAdditionalSnipsOnSameLine(content, file, line, matches);
    }

    private void checkAdditionalSnipsOnSameLine(String[] content, FileAccessSingle file, int line, List<SnippingMatch> matches) {
        List<String> strings = Arrays.asList(content);
        int indexOf = strings.indexOf("#" + this.getName());
        if (indexOf > 0) {
            String newContent = String.join((CharSequence)" ", strings.subList(indexOf + 1, content.length));
            this.getSnippingMatch(file, matches, new PreprocessorMatch(this, line, newContent));
        }
    }

    @Override
    public int getPriority() {
        return 20;
    }

    private CodePosition getPosition(FileAccessSingle file, int line, String[] preprocessorContent, int contentPosition) {
        int prefixLength = NAME.length() + 2;
        int startColumn = file.getFileContents().get(line - 1).lastIndexOf(String.join((CharSequence)" ", preprocessorContent));
        int endColumn = startColumn + contentPosition - 1;
        for (int i = 0; i < contentPosition; ++i) {
            endColumn += preprocessorContent[i].length();
        }
        return new CodePosition(file.getSourceFile(), line, startColumn - prefixLength, line, endColumn);
    }
}

