/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.blocks;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.blamejared.crafttweaker.impl_native.blocks.ExpandBlock;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraftforge.fml.LogicalSide;

public class ActionSetBlockProperty<T>
implements IUndoableAction {
    private final Block block;
    private final String propertyName;
    private final T newValue;
    private final T oldValue;
    private final Consumer<T> valueSetter;
    private Function<T, String> valueNameGetter;

    public ActionSetBlockProperty(Block block, String propertyName, T newValue, T oldValue, Consumer<T> valueSetter) {
        this.block = block;
        this.propertyName = propertyName;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.valueSetter = valueSetter;
        this.valueNameGetter = Object::toString;
    }

    public ActionSetBlockProperty(Block block, String propertyName, T newValue, T oldValue, Consumer<T> valueSetter, Function<T, String> valueNameGetter) {
        this.block = block;
        this.propertyName = propertyName;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.valueSetter = valueSetter;
        this.valueNameGetter = valueNameGetter;
    }

    @Override
    public void apply() {
        this.valueSetter.accept(this.newValue);
    }

    @Override
    public String describe() {
        return "Set the value of " + this.propertyName + " on " + ExpandBlock.getCommandString(this.block) + " to: '" + this.valueNameGetter.apply(this.newValue) + "'";
    }

    @Override
    public void undo() {
        this.valueSetter.accept(this.oldValue);
    }

    @Override
    public String describeUndo() {
        return "Reset the value of " + this.propertyName + " on " + ExpandBlock.getCommandString(this.block) + " to: '" + this.valueNameGetter.apply(this.oldValue) + "'";
    }

    @Override
    public boolean shouldApplyOn(LogicalSide side) {
        return this.shouldApplySingletons();
    }
}

