/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.brewing;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.actions.brewing.ActionBrewingBase;
import com.blamejared.crafttweaker.impl_native.potion.ExpandPotion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.IRegistryDelegate;

public class ActionRemovePotionBrewingRecipe
extends ActionBrewingBase {
    private final List removed = new ArrayList();
    private final Potion input;
    private final Potion output;
    private final IItemStack reagentStack;

    public ActionRemovePotionBrewingRecipe(List<IBrewingRecipe> recipes, Potion output, IItemStack reagentStack, Potion input) {
        super(recipes);
        this.output = output;
        this.input = input;
        this.reagentStack = reagentStack;
    }

    @Override
    public void apply() {
        Iterator vanillaIterator = PotionBrewing.field_185213_a.iterator();
        while (vanillaIterator.hasNext()) {
            Object mix = vanillaIterator.next();
            IRegistryDelegate<Potion> potionInput = this.getPotionInput(mix);
            IRegistryDelegate<Potion> potionOutput = this.getPotionOutput(mix);
            Ingredient reagent = this.getItemReagent(mix);
            if (potionInput == null || potionOutput == null || reagent == null) {
                throw new RuntimeException("Error getting potion from mix: " + mix + "! Please make an issue on the issue tracker!");
            }
            if (!((Potion)potionInput.get()).getRegistryName().equals((Object)this.input.getRegistryName()) || !((Potion)potionOutput.get()).getRegistryName().equals((Object)this.output.getRegistryName()) || !reagent.test(this.reagentStack.getInternal())) continue;
            this.removed.add(mix);
            vanillaIterator.remove();
        }
    }

    @Override
    public void undo() {
        for (Object o : this.removed) {
            IRegistryDelegate<Potion> potionInput = this.getPotionInput(o);
            Ingredient itemReagent = this.getItemReagent(o);
            IRegistryDelegate<Potion> potionOutput = this.getPotionOutput(o);
            if (potionInput == null || itemReagent == null || potionOutput == null) {
                CraftTweakerAPI.logError("Error getting mix entries! potionInput: %s, itemReagent: %s, potionOutput: %s", potionInput, itemReagent, potionOutput);
                continue;
            }
            PotionBrewing.func_193357_a((Potion)((Potion)potionInput.get()), (Item)itemReagent.func_193365_a()[0].func_77973_b(), (Potion)((Potion)potionOutput.get()));
        }
    }

    @Override
    public String describe() {
        return "Removing Brewing recipes that have an input of: " + ExpandPotion.getCommandString(this.input) + ", output of: " + ExpandPotion.getCommandString(this.output) + " and a reagent of: " + this.reagentStack;
    }

    @Override
    public String describeUndo() {
        return "Undoing removal of Brewing recipes that have an input of: " + ExpandPotion.getCommandString(this.input) + ", output of: " + ExpandPotion.getCommandString(this.output) + " and a reagent of: " + this.reagentStack;
    }
}

