/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.items.tooltips;

import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.impl.events.CTClientEventHandler;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.fml.LogicalSide;

public class ActionAddShiftedTooltip
implements IRuntimeAction {
    private final IIngredient stack;
    private final MCTextComponent content;
    private final MCTextComponent showMessage;

    public ActionAddShiftedTooltip(IIngredient stack, MCTextComponent content, MCTextComponent showMessage) {
        this.stack = stack;
        this.content = content;
        this.showMessage = showMessage;
    }

    @Override
    public void apply() {
        CTClientEventHandler.TOOLTIPS.computeIfAbsent(this.stack, iItemStack -> new LinkedList()).add((stack1, tooltip, isAdvanced) -> {
            KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_228046_af_;
            if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keyBindSneak.getKey().func_197937_c())) {
                tooltip.add(this.content);
            } else if (this.showMessage != null && !this.showMessage.getString().isEmpty()) {
                tooltip.add(this.showMessage);
            }
        });
    }

    @Override
    public String describe() {
        return "Adding \"" + this.content.asString() + "\" to the shift tooltip for: " + this.stack.getCommandString();
    }

    @Override
    public boolean shouldApplyOn(LogicalSide side) {
        return side.isClient();
    }
}

