/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.items.tooltips;

import com.blamejared.crafttweaker.api.actions.IRuntimeAction;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.impl.events.CTClientEventHandler;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import java.util.LinkedList;
import net.minecraftforge.fml.LogicalSide;

public class ActionAddTooltip
implements IRuntimeAction {
    private final IIngredient stack;
    private final MCTextComponent content;

    public ActionAddTooltip(IIngredient stack, MCTextComponent content) {
        this.stack = stack;
        this.content = content;
    }

    @Override
    public void apply() {
        CTClientEventHandler.TOOLTIPS.computeIfAbsent(this.stack, iItemStack -> new LinkedList()).add((stack1, tooltip, isAdvanced) -> tooltip.add(this.content));
    }

    @Override
    public String describe() {
        return "Adding \"" + this.content.asString() + "\" to the tooltip for: " + this.stack.getCommandString();
    }

    @Override
    public boolean shouldApplyOn(LogicalSide side) {
        return side.isClient();
    }
}

