/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes.generic;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.actions.recipes.generic.ActionWholeRegistryBase;
import com.blamejared.crafttweaker.impl.managers.RecipeManagerWrapper;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;

public class ActionRemoveAllGenericRecipes
extends ActionWholeRegistryBase {
    @Override
    public void apply() {
        Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> recipesByType = this.getRecipesByType();
        TreeMap<String, Integer> numberOfRemovedRecipesByType = new TreeMap<String, Integer>();
        int totalRemoved = 0;
        for (IRecipeType<?> recipeType : recipesByType.keySet()) {
            int removedRecipes = this.remove(recipesByType.get(recipeType));
            if (removedRecipes <= 0) continue;
            totalRemoved += removedRecipes;
            String commandString = new RecipeManagerWrapper(recipeType).getCommandString();
            numberOfRemovedRecipesByType.put(commandString, removedRecipes);
        }
        int managerCount = numberOfRemovedRecipesByType.size();
        String recipeTypeList = this.makeRecipeList(numberOfRemovedRecipesByType);
        CraftTweakerAPI.logInfo("Removed %s recipes across these %s managers: %s", totalRemoved, managerCount, recipeTypeList);
    }

    private int remove(Map<ResourceLocation, IRecipe<?>> map) {
        int size = map.size();
        map.clear();
        return size;
    }

    @Override
    public String describe() {
        return "Removing all recipes";
    }
}

