/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.villagers;

import com.blamejared.crafttweaker.api.villagers.ITradeRemover;
import com.blamejared.crafttweaker.impl.actions.villagers.ActionTradeBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;

public class ActionRemoveTrade
extends ActionTradeBase {
    private final ITradeRemover tradeRemover;
    private final List<VillagerTrades.ITrade> removed;

    public ActionRemoveTrade(VillagerProfession profession, int level, ITradeRemover tradeRemover) {
        super(profession, level);
        this.tradeRemover = tradeRemover;
        this.removed = new ArrayList<VillagerTrades.ITrade>();
    }

    @Override
    public void apply() {
        List<VillagerTrades.ITrade> tradeList = this.getTradeList();
        tradeList.forEach(iTrade -> {
            if (this.tradeRemover.shouldRemove((VillagerTrades.ITrade)iTrade)) {
                this.removed.add((VillagerTrades.ITrade)iTrade);
            }
        });
        tradeList.removeAll(this.removed);
        this.setTradeList(tradeList);
    }

    @Override
    public String describe() {
        return String.format("Removing Villager trade for Profession: '%s' and Level: '%s'", this.profession.toString(), this.level);
    }

    @Override
    public void undo() {
        List<VillagerTrades.ITrade> tradeList = this.getTradeList();
        tradeList.addAll(this.removed);
        this.setTradeList(tradeList);
    }

    @Override
    public String describeUndo() {
        return String.format("Undoing removal of Villager trade for Profession: '%s' and Level: '%s'", this.profession.toString(), this.level);
    }
}

