/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.brackets;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.BracketValidator;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.brackets.BracketHandlers;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.BracketValidators")
public class BracketValidators {
    private BracketValidators() {
    }

    @ZenCodeType.Method
    @BracketValidator(value="block")
    public static boolean validateBlockBracket(String tokens) {
        return BracketValidators.validateBracket("block", tokens, BracketHandlers::getBlock);
    }

    @ZenCodeType.Method
    @BracketValidator(value="blockmaterial")
    public static boolean validateBlockMaterialBracket(String tokens) {
        return BracketValidators.validateBracket("blockmaterial", tokens, BracketHandlers::getBlockMaterial);
    }

    @ZenCodeType.Method
    @BracketValidator(value="blockstate")
    public static boolean validateBlockStateMaterialBracket(String tokens) {
        String[] split = tokens.split(":");
        if (split.length > 4 || split.length < 2) {
            CraftTweakerAPI.logError("Invalid BEP Syntax: <blockstate:%s>! Correct syntax is <blockstate:modid:block_name:properties> or <blockstate:modid:block_name>!", tokens);
            return false;
        }
        String resourceLocation = split[0] + ":" + split[1];
        if (ResourceLocation.func_208304_a((String)resourceLocation) == null) {
            CraftTweakerAPI.logError("Invalid Block name for Blockstate BEP. '%s' does not appear to be a valid resource location!", resourceLocation);
            return false;
        }
        String properties = split.length == 3 ? split[2] : "";
        BlockState blockState = BracketHandlers.getBlockState(resourceLocation, properties);
        return blockState != null || BracketValidators.isRegistryUnlocked(ForgeRegistries.BLOCKS);
    }

    @ZenCodeType.Method
    @BracketValidator(value="directionaxis")
    public static boolean validateDirectionAxisBracket(String tokens) {
        return BracketValidators.validateBracket("directionaxis", tokens, BracketHandlers::getDirectionAxis);
    }

    @ZenCodeType.Method
    @BracketValidator(value="effect")
    public static boolean validateEffectBracket(String tokens) {
        if (BracketValidators.isRegistryUnlocked(ForgeRegistries.POTIONS) && tokens.split(":").length != 2) {
            CraftTweakerAPI.logError("Invalid Bracket Syntax: <effect:" + tokens + ">! Syntax is <effect:modid:potionname>", new Object[0]);
            return false;
        }
        return BracketValidators.validateBracket("effect", tokens, BracketHandlers::getEffect);
    }

    @ZenCodeType.Method
    @BracketValidator(value="enchantment")
    public static boolean validateEnchantment(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Enchantment BEP <enchantment:%s> does not seem to be lower-case!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            CraftTweakerAPI.logError("Could not get enchantment '%s': not a valid bracket handler, syntax is <enchantment:modid:name>", tokens);
            return false;
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.ENCHANTMENTS.containsKey(key)) {
            CraftTweakerAPI.logError("Could not get enchantment '%s': the enchantment isn't registered", tokens);
            return false;
        }
        return true;
    }

    @ZenCodeType.Method
    @BracketValidator(value="entityclassification")
    public static boolean validateEntityClassification(String tokens) {
        return BracketValidators.validateBracket("entityclassification", tokens, BracketHandlers::getEntityClassification);
    }

    @ZenCodeType.Method
    @BracketValidator(value="entitytype")
    public static boolean validateEntityType(String tokens) {
        if (BracketValidators.isRegistryUnlocked(ForgeRegistries.ENTITIES) && ResourceLocation.func_208304_a((String)tokens) == null) {
            CraftTweakerAPI.logError("Invalid Bracket Syntax: <entitytype:" + tokens + ">! Syntax is <entitytype:modid:entity_type_name>", new Object[0]);
            return false;
        }
        return BracketValidators.validateBracket("entitytype", tokens, BracketHandlers::getEntityType);
    }

    @ZenCodeType.Method
    @BracketValidator(value="fluid")
    public static boolean validateFluidStack(String tokens) {
        ResourceLocation resourceLocation = ResourceLocation.func_208304_a((String)tokens);
        if (resourceLocation == null) {
            CraftTweakerAPI.logError("Could not get BEP <fluid:" + tokens + ">. Syntax is <fluid:modid:fluidname>", new Object[0]);
            return false;
        }
        if (BracketValidators.isRegistryUnlocked(ForgeRegistries.FLUIDS) || ForgeRegistries.FLUIDS.containsKey(resourceLocation)) {
            return true;
        }
        CraftTweakerAPI.logError("Could not get fluid for <fluid:" + tokens + ">. Fluid does not appear to exist!", new Object[0]);
        return false;
    }

    @ZenCodeType.Method
    @BracketValidator(value="item")
    public static boolean validateItemBracket(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Item BEP <item:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            CraftTweakerAPI.logError("Could not get item with name: <item:" + tokens + ">! Syntax is <item:modid:itemname>", new Object[0]);
            return false;
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (((ForgeRegistry)ForgeRegistries.ITEMS).isLocked() && !ForgeRegistries.ITEMS.containsKey(key)) {
            CraftTweakerAPI.logError("Could not get item with name: <item:" + tokens + ">! Item does not appear to exist!", new Object[0]);
            return false;
        }
        return true;
    }

    @ZenCodeType.Method
    @BracketValidator(value="recipemanager")
    public static boolean validateRecipeManagerBracket(String tokens) {
        return BracketValidators.validateBracket("recipemanager", tokens, BracketHandlers::getRecipeManager);
    }

    @ZenCodeType.Method
    @BracketValidator(value="profession")
    public static boolean validateProfessionBracket(String tokens) {
        if (BracketValidators.isRegistryUnlocked(ForgeRegistries.PROFESSIONS) && tokens.split(":").length != 2) {
            CraftTweakerAPI.logError("Invalid Bracket Syntax: <profession:" + tokens + ">! Syntax is <profession:modid:profession_name>", new Object[0]);
            return false;
        }
        return BracketValidators.validateBracket("profession", tokens, BracketHandlers::getProfession);
    }

    @ZenCodeType.Method
    @BracketValidator(value="resource")
    public static boolean validateResourceBracket(String tokens) {
        return ResourceLocation.func_208304_a((String)tokens) != null;
    }

    @ZenCodeType.Method
    @BracketValidator(value="tooltype")
    public static boolean validateToolTypeBracket(String tokens) {
        return tokens.chars().allMatch(c -> 97 <= c && c <= 122 || c == 95);
    }

    public static boolean validateBracket(String bracketName, String tokens, Function<String, ?> bracketMethod, boolean logError) {
        try {
            return bracketMethod.apply(tokens) != null;
        }
        catch (Exception e) {
            if (logError) {
                CraftTweakerAPI.logThrowing("Error validating BEP <%s:%s>", e, bracketName, tokens);
            }
            return false;
        }
    }

    public static boolean validateBracket(String bracketName, String tokens, Function<String, ?> bracketMethod) {
        return BracketValidators.validateBracket(bracketName, tokens, bracketMethod, true);
    }

    private static boolean isRegistryUnlocked(IForgeRegistry<?> registryEntries) {
        if (!(registryEntries instanceof ForgeRegistry)) {
            return false;
        }
        return !((ForgeRegistry)registryEntries).isLocked();
    }
}

