/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.crafttweaker;

import com.blamejared.crafttweaker.api.text.FormattedTextComponent;
import com.blamejared.crafttweaker.impl.commands.CTCommands;
import com.blamejared.crafttweaker.impl.commands.CommandCallerPlayer;
import com.blamejared.crafttweaker.impl.commands.CommandUtilities;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStackMutable;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerBlock;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerItem;
import com.blamejared.crafttweaker.impl_native.blocks.ExpandBlock;
import com.blamejared.crafttweaker.impl_native.blocks.ExpandBlockState;
import com.blamejared.crafttweaker.impl_native.entity.attribute.ExpandAttribute;
import com.blamejared.crafttweaker.impl_native.util.ExpandEquipmentSlotType;
import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.apache.logging.log4j.util.TriConsumer;

public final class HandCommands {
    private HandCommands() {
    }

    public static void registerHandCommands() {
        CTCommands.registerCommand(CTCommands.playerCommand("hand", "Outputs the name and tags (if any) of the item in your hand", (player, stack) -> {
            Item item = stack.func_77973_b();
            HandCommands.sendBasicItemInformation(player, stack);
            if (item instanceof BlockItem) {
                HandCommands.sendBlockInformation(player, (BlockItem)stack.func_77973_b());
            }
            if (item instanceof BucketItem && ((BucketItem)item).getFluid() != Fluids.field_204541_a) {
                HandCommands.sendBucketInformation(player, (BucketItem)stack.func_77973_b());
            }
            stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(iFluidHandlerItem -> HandCommands.sendFluidInformation(player, iFluidHandlerItem));
            HandCommands.sendTagsInformation(player, item);
            return 0;
        }));
        HandCommands.subCommand("registryName", "Outputs the registry name of the item in your hand", (player, stack) -> {
            HandCommands.sendCopyingHand(player, "Item", Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString());
            return 0;
        });
        HandCommands.subCommand("tags", "Outputs the tags of the item in your hand", (player, stack) -> {
            Collection<String> tags = HandCommands.sendTagsInformation(player, stack.func_77973_b());
            if (tags.isEmpty()) {
                CommandUtilities.send("Item has no tags", player);
                return 0;
            }
            tags.stream().findFirst().ifPresent(it -> CommandUtilities.copy(player, it));
            return 0;
        });
        HandCommands.subCommand("vanilla", "Outputs the name and tags (if any) of the item in your hand in vanilla format", (player, stack) -> {
            Item item = stack.func_77973_b();
            HandCommands.sendBasicVanillaItemInformation(player, stack);
            if (stack.func_77942_o()) {
                HandCommands.sendVanillaNbtInformation(player, (INBT)Objects.requireNonNull(stack.func_77978_p()));
            }
            if (item instanceof BucketItem && ((BucketItem)item).getFluid() != Fluids.field_204541_a) {
                HandCommands.sendVanillaBucketInformation(player, (BucketItem)stack.func_77973_b());
            }
            HandCommands.sendVanillaTagsInformation(player, item);
            return 0;
        });
        HandCommands.subCommand("attributes", "Outputs the AttributeModifiers of the item in your hand", (player, stack) -> {
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                Map modifiers = stack.func_111283_C(slot).asMap();
                if (modifiers.isEmpty()) continue;
                String equipmentCS = ExpandEquipmentSlotType.getCommandString(slot);
                CommandUtilities.sendCopying((TextComponent)new FormattedTextComponent(TextFormatting.DARK_AQUA + "Attributes for: " + TextFormatting.GREEN + equipmentCS, new Object[0]), equipmentCS, player);
                modifiers.forEach((attribute, attributeModifiers) -> {
                    String attributeCS = ExpandAttribute.getCommandString(attribute);
                    CommandUtilities.sendCopying((TextComponent)new FormattedTextComponent(TextFormatting.YELLOW + "- " + TextFormatting.GREEN + attributeCS, new Object[0]), attributeCS, player);
                    attributeModifiers.forEach(attributeModifier -> {
                        HandCommands.sendAttributePropertyInformation(player, "Name", attributeModifier.func_111166_b());
                        HandCommands.sendAttributePropertyInformation(player, "ID", attributeModifier.func_111167_a().toString());
                        HandCommands.sendAttributePropertyInformation(player, "Operation", attributeModifier.func_220375_c().name());
                        HandCommands.sendAttributePropertyInformation(player, "Amount", attributeModifier.func_111164_d() + "");
                    });
                });
            }
            HandCommands.sendCopyingHand(player, "Item", Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString());
            return 0;
        });
    }

    private static void subCommand(String name, String desc, CommandCallerPlayer caller) {
        CTCommands.registerCommand("hand", CTCommands.playerCommand(name, desc, caller));
    }

    private static void sendBasicItemInformation(PlayerEntity player, ItemStack target) {
        String output = new MCItemStackMutable(target).getCommandString();
        HandCommands.sendCopyingHand(player, "Item", output);
    }

    private static void sendBlockInformation(PlayerEntity player, BlockItem target) {
        HandCommands.sendBlockInformation(player, target.func_179223_d());
    }

    private static void sendBlockInformation(PlayerEntity player, Block target) {
        HandCommands.sendHand(player, "Block", ExpandBlock.getCommandString(target.getBlock()));
        HandCommands.sendHand(player, "BlockState", ExpandBlockState.getCommandString(target.func_176223_P()));
    }

    private static void sendBucketInformation(PlayerEntity player, BucketItem target) {
        if (target.getFluid() == Fluids.field_204541_a) {
            return;
        }
        HandCommands.sendHand(player, "Fluid BlockState", ExpandBlockState.getCommandString(target.getFluid().func_207188_f().func_206883_i()));
    }

    private static void sendFluidInformation(PlayerEntity player, IFluidHandlerItem item) {
        int tanks = item.getTanks();
        if (tanks <= 0) {
            return;
        }
        if (item.getTanks() == 1) {
            HandCommands.sendSingleFluidInformation(player, item.getFluidInTank(0), -1);
            return;
        }
        HandCommands.sendMultipleFluidInformation(player, item, tanks);
    }

    private static void sendMultipleFluidInformation(PlayerEntity player, IFluidHandlerItem item, int tanks) {
        IntStream.range(0, tanks).mapToObj(it -> new AbstractInt2ObjectMap.BasicEntry(it, (Object)item.getFluidInTank(it))).filter(it -> !((FluidStack)it.getValue()).isEmpty()).forEach(it -> HandCommands.sendSingleFluidInformation(player, (FluidStack)it.getValue(), it.getIntKey()));
    }

    private static void sendSingleFluidInformation(PlayerEntity player, FluidStack stack, int id) {
        HandCommands.sendHand(player, id < 0 ? "Fluid" : "Fluid #" + id, new MCFluidStackMutable(stack).getCommandString());
    }

    private static Collection<String> sendTagsInformation(PlayerEntity player, Item item) {
        ArrayList<String> tags = new ArrayList<String>(HandCommands.sendItemTagsInformation(player, item));
        if (item instanceof BlockItem) {
            tags.addAll(HandCommands.sendBlockTagsInformation(player, (BlockItem)item));
        }
        return tags;
    }

    private static Collection<String> sendItemTagsInformation(PlayerEntity player, Item item) {
        return HandCommands.sendTagsInformation(player, "Item Tag Entries", TagManagerItem.INSTANCE, ItemTags.func_199903_a(), item);
    }

    private static Collection<String> sendBlockTagsInformation(PlayerEntity player, BlockItem item) {
        return HandCommands.sendTagsInformation(player, "Block Tag Entries", TagManagerBlock.INSTANCE, BlockTags.func_199896_a(), item.func_179223_d());
    }

    private static <T> Collection<String> sendTagsInformation(PlayerEntity player, String header, TagManager<T> manager, ITagCollection<T> tagCollection, T target) {
        Collection tags = tagCollection.func_199913_a(target);
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        CommandUtilities.send((ITextComponent)new FormattedTextComponent(CommandUtilities.color(header, TextFormatting.DARK_AQUA), new Object[0]), player);
        return tags.stream().map(id -> new MCTag((ResourceLocation)id, manager)).map(MCTag::getCommandString).peek(it -> HandCommands.sendTagHand(player, it)).collect(Collectors.toList());
    }

    private static void sendBasicVanillaItemInformation(PlayerEntity player, ItemStack target) {
        String output = Objects.requireNonNull(target.func_77973_b().getRegistryName()).toString();
        HandCommands.sendCopyingHand(player, "Item", output);
    }

    private static void sendVanillaNbtInformation(PlayerEntity player, INBT nbt) {
        HandCommands.sendHand(player, "NBT", nbt.func_150285_a_());
    }

    private static void sendVanillaBucketInformation(PlayerEntity player, BucketItem target) {
        if (target.getFluid() == Fluids.field_204541_a) {
            return;
        }
        HandCommands.sendHand(player, "Fluid BlockState", Objects.requireNonNull(target.getFluid().getRegistryName()).toString());
    }

    private static void sendVanillaTagsInformation(PlayerEntity player, Item item) {
        HandCommands.sendVanillaItemTagsInformation(player, item);
        if (item instanceof BlockItem) {
            HandCommands.sendVanillaBlockTagsInformation(player, (BlockItem)item);
        }
    }

    private static void sendVanillaItemTagsInformation(PlayerEntity player, Item item) {
        HandCommands.sendVanillaTagsInformation(player, "Item Tag Entries", ItemTags.func_199903_a(), item);
    }

    private static void sendVanillaBlockTagsInformation(PlayerEntity player, BlockItem item) {
        HandCommands.sendVanillaTagsInformation(player, "Block Tag Entries", BlockTags.func_199896_a(), item.func_179223_d());
    }

    private static <T> void sendVanillaTagsInformation(PlayerEntity player, String header, ITagCollection<T> tagCollection, T target) {
        Collection tags = tagCollection.func_199913_a(target);
        if (tags.isEmpty()) {
            return;
        }
        CommandUtilities.send((ITextComponent)new FormattedTextComponent(CommandUtilities.color(header, TextFormatting.DARK_AQUA), new Object[0]), player);
        tags.stream().map(id -> "#" + id).forEach(it -> HandCommands.sendTagHand(player, it));
    }

    private static void sendAttributePropertyInformation(PlayerEntity player, String propertyName, String value) {
        CommandUtilities.sendCopying((TextComponent)new FormattedTextComponent(TextFormatting.YELLOW + "\t- %s: " + TextFormatting.AQUA + value, propertyName), value, player);
    }

    private static void sendHand(PlayerEntity receiver, String messagePrefix, String target) {
        HandCommands.sendHand(receiver, messagePrefix, target, (TriConsumer<TextComponent, String, PlayerEntity>)((TriConsumer)CommandUtilities::sendCopying));
    }

    private static void sendCopyingHand(PlayerEntity receiver, String messagePrefix, String target) {
        HandCommands.sendHand(receiver, messagePrefix, target, (TriConsumer<TextComponent, String, PlayerEntity>)((TriConsumer)CommandUtilities::sendCopyingAndCopy));
    }

    private static void sendHand(PlayerEntity receiver, String messagePrefix, String target, TriConsumer<TextComponent, String, PlayerEntity> consumer) {
        consumer.accept((Object)new FormattedTextComponent(messagePrefix + ": %s", CommandUtilities.color(target, TextFormatting.GREEN)), (Object)target, (Object)receiver);
    }

    private static void sendTagHand(PlayerEntity receiver, String tag) {
        CommandUtilities.sendCopying((TextComponent)new FormattedTextComponent("\t%s %s", CommandUtilities.color("- ", TextFormatting.YELLOW), CommandUtilities.color(tag, TextFormatting.AQUA)), tag, receiver);
    }
}

