/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.custom;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.commands.custom.MCCommandSource")
@Document(value="vanilla/api/commands/custom/MCCommandSource")
@ZenWrapper(wrappedClass="net.minecraft.command.CommandSource", displayStringFormat="%s.toString()")
public class MCCommandSource {
    private final CommandSource internal;

    public MCCommandSource(CommandSource internal) {
        this.internal = internal;
    }

    public CommandSource getInternal() {
        return this.internal;
    }

    @ZenCodeType.Method
    public Collection<String> getTeamNames() {
        return this.getInternal().func_197012_k();
    }

    @ZenCodeType.Method
    public MCCommandSource withFeedbackDisabled() {
        return new MCCommandSource(this.getInternal().func_197031_a());
    }

    @ZenCodeType.Method
    public boolean hasPermissionLevel(int p_197034_1_) {
        return this.getInternal().func_197034_c(p_197034_1_);
    }

    @ZenCodeType.Method
    public Collection<String> getPlayerNames() {
        return this.getInternal().func_197011_j();
    }

    @ZenCodeType.Method
    public MCCommandSource withPermissionLevel(int p_197033_1_) {
        return new MCCommandSource(this.getInternal().func_197033_a(p_197033_1_));
    }

    @ZenCodeType.Method
    public String getName() {
        return this.getInternal().func_197037_c();
    }

    @ZenCodeType.Method
    public Collection<String> getTargetedEntity() {
        return this.getInternal().func_211270_p();
    }

    @ZenCodeType.Method
    public MCCommandSource withMinPermissionLevel(int p_197026_1_) {
        return new MCCommandSource(this.getInternal().func_197026_b(p_197026_1_));
    }

    @ZenCodeType.Method
    public boolean isPlayer() {
        return this.getInternal().func_197022_f() instanceof ServerPlayerEntity;
    }

    @ZenCodeType.Method
    public @ZenCodeType.Nullable PlayerEntity getPlayer() {
        try {
            return this.getInternal().func_197035_h();
        }
        catch (CommandSyntaxException e) {
            CraftTweakerAPI.logError("Could not get Player: %s", new Object[]{e});
            return null;
        }
    }

    @ZenCodeType.Method
    public void sendErrorMessage(String message) {
        this.getInternal().func_197021_a((ITextComponent)new StringTextComponent(message));
    }

    @ZenCodeType.Method
    public void sendFeedback(String feedback, boolean allowLogging) {
        this.getInternal().func_197030_a((ITextComponent)new StringTextComponent(feedback), allowLogging);
    }
}

