/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands.script_examples;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.commands.CTCommands;
import com.blamejared.crafttweaker.impl.commands.CommandImpl;
import com.blamejared.crafttweaker.impl.commands.script_examples.ResourceManagerSourceFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.io.IOUtils;
import org.openzen.zencode.shared.SourceFile;

public class ExamplesCommand
extends CommandImpl {
    @Deprecated
    public static final String name = "examples";
    @Deprecated
    public static final String description = "Creates example scripts based on the mods installed, and opens the example folder";

    public ExamplesCommand() {
        super(name, description, ExamplesCommand::execute);
    }

    public static void register() {
        CTCommands.registerCommand(new ExamplesCommand());
    }

    private static int execute(PlayerEntity playerEntity, ItemStack stack) {
        MinecraftServer server = ((ServerPlayerEntity)playerEntity).field_71133_b;
        DataPackRegistries dataPackRegistries = server.getDataPackRegistries();
        IResourceManager resourceManager = dataPackRegistries.func_240970_h_();
        for (ResourceLocation file : resourceManager.func_199003_a("scripts", n -> n.endsWith(".zs"))) {
            ExamplesCommand.writeScriptFile(new ResourceManagerSourceFile(file, resourceManager));
        }
        playerEntity.func_145747_a((ITextComponent)new StringTextComponent("Wrote examples to the 'examples' folder inside the scripts folder."), CraftTweaker.CRAFTTWEAKER_UUID);
        return 0;
    }

    @Deprecated
    public static void writeScriptFile(SourceFile sourceFile) {
        File file = new File(ExamplesCommand.getExamplesDir(), sourceFile.getFilename());
        if (file.exists()) {
            CraftTweakerAPI.logInfo("Skip writing example file '%s' since it already exists", file);
            return;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            CraftTweakerAPI.logError("Could not create folder %s", file.getParentFile());
            return;
        }
        try (FileWriter writer = new FileWriter(file, false);
             Reader reader = sourceFile.open();){
            IOUtils.copy((Reader)reader, (Writer)writer);
        }
        catch (IOException e) {
            CraftTweakerAPI.logger.throwingWarn("Could not write script example: ", e);
        }
    }

    private static File getExamplesDir() {
        return new File(CraftTweakerAPI.SCRIPT_DIR, name);
    }
}

