/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.entity;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.entity.CTEntityIngredient;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.entity.MCEntityType")
@Document(value="vanilla/api/entities/MCEntityType")
@ZenWrapper(wrappedClass="net.minecraft.entity.EntityType", displayStringFormat="%s.getCommandString()")
public class MCEntityType
implements CommandStringDisplayable {
    private final EntityType<?> internal;

    public MCEntityType(@Nonnull EntityType<?> internal) {
        this.internal = Objects.requireNonNull(internal);
    }

    @ZenCodeType.Method
    public Entity create(World world) {
        return this.getInternal().func_200721_a(world);
    }

    @ZenCodeType.Getter(value="classification")
    public EntityClassification getClassification() {
        return this.getInternal().func_220339_d();
    }

    @ZenCodeType.Getter(value="serializable")
    public boolean isSerializable() {
        return this.getInternal().func_200715_a();
    }

    @ZenCodeType.Getter(value="summonable")
    public boolean isSummonable() {
        return this.getInternal().func_200720_b();
    }

    @ZenCodeType.Getter(value="immuneToFire")
    public boolean isImmuneToFire() {
        return this.getInternal().func_220338_c();
    }

    @ZenCodeType.Getter(value="translationKey")
    public String getTranslationKey() {
        return this.getInternal().func_210760_d();
    }

    @ZenCodeType.Getter(value="name")
    public String getName() {
        return this.getInternal().func_212546_e().getString();
    }

    @ZenCodeType.Getter(value="lootTable")
    public String getLootTable() {
        return this.getInternal().func_220348_g().toString();
    }

    @ZenCodeType.Getter(value="width")
    public float getWidth() {
        return this.getInternal().func_220333_h();
    }

    @ZenCodeType.Getter(value="height")
    public float getHeight() {
        return this.getInternal().func_220344_i();
    }

    @Override
    @ZenCodeType.Getter(value="commandString")
    public String getCommandString() {
        return "<entityType:" + this.getInternal().getRegistryName() + ">";
    }

    public EntityType<?> getInternal() {
        return this.internal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCEntityType that = (MCEntityType)o;
        return this.getInternal().equals(that.getInternal());
    }

    public int hashCode() {
        return this.getInternal().hashCode();
    }

    @ZenCodeType.Caster(implicit=true)
    public CTEntityIngredient asEntityIngredient() {
        return new CTEntityIngredient.EntityTypeIngredient(this);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public CTEntityIngredient asList(CTEntityIngredient other) {
        ArrayList<CTEntityIngredient> elements = new ArrayList<CTEntityIngredient>();
        elements.add(this.asEntityIngredient());
        elements.add(other);
        return new CTEntityIngredient.CompoundEntityIngredient(elements);
    }
}

