/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.vanilla;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl.predicate.IntRangePredicate;
import com.blamejared.crafttweaker.impl.predicate.TargetedEntity;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.vanilla.EntityScores")
@Document(value="vanilla/api/loot/conditions/vanilla/EntityScores")
public final class EntityScoresLootConditionTypeBuilder
implements ILootConditionTypeBuilder {
    private final Map<String, IntRangePredicate> ranges = new LinkedHashMap<String, IntRangePredicate>();
    private TargetedEntity targetedEntity;

    EntityScoresLootConditionTypeBuilder() {
    }

    @ZenCodeType.Method
    public EntityScoresLootConditionTypeBuilder withTargetedEntity(TargetedEntity entity) {
        this.targetedEntity = entity;
        return this;
    }

    @ZenCodeType.Method
    public EntityScoresLootConditionTypeBuilder withMinimumScore(String name, int min) {
        this.ranges.put(name, IntRangePredicate.mergeLowerBound(this.ranges.get(name), min));
        return this;
    }

    @ZenCodeType.Method
    public EntityScoresLootConditionTypeBuilder withMaximumScore(String name, int max) {
        this.ranges.put(name, IntRangePredicate.mergeUpperBound(this.ranges.get(name), max));
        return this;
    }

    @ZenCodeType.Method
    public EntityScoresLootConditionTypeBuilder withRangedScore(String name, int min, int max) {
        this.ranges.put(name, IntRangePredicate.bounded(min, max));
        return this;
    }

    @ZenCodeType.Method
    public EntityScoresLootConditionTypeBuilder withExactScore(String name, int value) {
        return this.withRangedScore(name, value, value);
    }

    @Override
    public ILootCondition finish() {
        if (this.targetedEntity == null) {
            throw new IllegalStateException("Targeted entity not defined for an 'EntityScores' condition");
        }
        if (this.ranges.isEmpty()) {
            CraftTweakerAPI.logWarning("An 'EntityScores' condition has an empty set of scores to check: this will always match!", new Object[0]);
        }
        List matchers = this.ranges.entrySet().stream().map(this::convertToMatcher).collect(Collectors.toList());
        return context -> {
            Entity entity = this.targetedEntity.getLootContextDiscriminator().apply(context);
            if (entity == null) {
                return false;
            }
            Scoreboard scoreboard = entity.func_130014_f_().func_96441_U();
            return matchers.stream().allMatch(it -> it.test(entity, scoreboard));
        };
    }

    private BiPredicate<Entity, Scoreboard> convertToMatcher(Map.Entry<String, IntRangePredicate> entry) {
        return this.makeMatcher(entry.getKey(), entry.getValue());
    }

    private BiPredicate<Entity, Scoreboard> makeMatcher(String name, IntRangePredicate range) {
        return (entity, scoreboard) -> {
            ScoreObjective objective = scoreboard.func_96518_b(name);
            if (objective == null) {
                return false;
            }
            String scoreboardName = entity.func_195047_I_();
            return scoreboard.func_178819_b(scoreboardName, objective) && range.match(scoreboard.func_96529_a(scoreboardName, objective).func_96652_c());
        };
    }
}

