/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.vanilla;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl_native.loot.ExpandLootContext;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.Consumer;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.vanilla.LocationCheck")
@Document(value="vanilla/api/loot/conditions/vanilla/LocationCheck")
public final class LocationCheckLootConditionTypeBuilder
implements ILootConditionTypeBuilder {
    private BlockPos offset = new BlockPos(0, 0, 0);
    private com.blamejared.crafttweaker.impl.predicate.LocationPredicate predicate = new com.blamejared.crafttweaker.impl.predicate.LocationPredicate();

    LocationCheckLootConditionTypeBuilder() {
    }

    @ZenCodeType.Method
    public LocationCheckLootConditionTypeBuilder withOffset(BlockPos pos) {
        this.offset = pos;
        return this;
    }

    @ZenCodeType.Method
    public LocationCheckLootConditionTypeBuilder withXOffset(int x) {
        return this.withOffset(new BlockPos(x, this.offset.func_177956_o(), this.offset.func_177952_p()));
    }

    @ZenCodeType.Method
    public LocationCheckLootConditionTypeBuilder withYOffset(int y) {
        return this.withOffset(new BlockPos(this.offset.func_177958_n(), y, this.offset.func_177952_p()));
    }

    @ZenCodeType.Method
    public LocationCheckLootConditionTypeBuilder withZOffset(int z) {
        return this.withOffset(new BlockPos(this.offset.func_177958_n(), this.offset.func_177956_o(), z));
    }

    @ZenCodeType.Method
    public LocationCheckLootConditionTypeBuilder withLocationPredicate(Consumer<com.blamejared.crafttweaker.impl.predicate.LocationPredicate> builder) {
        com.blamejared.crafttweaker.impl.predicate.LocationPredicate predicate = new com.blamejared.crafttweaker.impl.predicate.LocationPredicate();
        builder.accept(predicate);
        this.predicate = predicate;
        return this;
    }

    @Override
    public ILootCondition finish() {
        LocationPredicate predicate = (LocationPredicate)this.predicate.toVanillaPredicate();
        return context -> {
            Vector3d origin = ExpandLootContext.getOrigin(context);
            World world = ExpandLootContext.getWorld(context);
            Vector3d offset = origin == null ? null : origin.func_72441_c((double)this.offset.func_177958_n(), (double)this.offset.func_177956_o(), (double)this.offset.func_177952_p());
            return offset != null && world instanceof ServerWorld && predicate.func_193452_a((ServerWorld)world, offset.func_82615_a(), offset.func_82617_b(), offset.func_82616_c());
        };
    }
}

