/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.vanilla;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl.predicate.IntRangePredicate;
import com.blamejared.crafttweaker.impl_native.loot.ExpandLootContext;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.world.World;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.vanilla.TimeCheck")
@Document(value="vanilla/api/loot/conditions/vanilla/TimeCheck")
public final class TimeCheckLootConditionTypeBuilder
implements ILootConditionTypeBuilder {
    private int timePeriod = 0;
    private IntRangePredicate value = IntRangePredicate.unbounded();

    TimeCheckLootConditionTypeBuilder() {
    }

    @ZenCodeType.Method
    public TimeCheckLootConditionTypeBuilder withTimePeriod(int period) {
        this.timePeriod = period;
        return this;
    }

    @ZenCodeType.Method
    public TimeCheckLootConditionTypeBuilder withMinimumValue(int min) {
        this.value = IntRangePredicate.mergeLowerBound(this.value, min);
        return this;
    }

    @ZenCodeType.Method
    public TimeCheckLootConditionTypeBuilder withMaximumValue(int max) {
        this.value = IntRangePredicate.mergeUpperBound(this.value, max);
        return this;
    }

    @ZenCodeType.Method
    public TimeCheckLootConditionTypeBuilder withRangedValue(int min, int max) {
        this.value = IntRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public TimeCheckLootConditionTypeBuilder withExactValue(int value) {
        return this.withRangedValue(value, value);
    }

    @Override
    public ILootCondition finish() {
        if (this.value.isAny()) {
            throw new IllegalStateException("A 'TimeCheck' condition needs a time range");
        }
        if (this.timePeriod < 0) {
            throw new IllegalStateException("A 'TimeCheck' condition needs a positive period");
        }
        return context -> {
            World world = ExpandLootContext.getWorld(context);
            long time = world.func_72820_D();
            int actualTime = (int)(this.timePeriod > 0 ? time % (long)this.timePeriod : time);
            return this.value.match(actualTime);
        };
    }
}

