/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.modifiers;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.modifiers.ILootModifier;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.loot.LootContext;
import net.minecraft.util.Util;
import net.minecraftforge.common.util.Lazy;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.modifiers.CommonLootModifiers")
@Document(value="vanilla/api/loot/modifiers/CommonLootModifiers")
public final class CommonLootModifiers {
    private static final Lazy<ILootModifier> IDENTITY = Lazy.concurrentOf(() -> (loot, context) -> loot);
    private static final Lazy<ILootModifier> LOOT_CLEARING_MODIFIER = Lazy.concurrentOf(() -> (loot, context) -> new ArrayList());

    @ZenCodeType.Method
    public static ILootModifier add(IItemStack stack) {
        return stack.isEmpty() ? (ILootModifier)IDENTITY.get() : (loot, context) -> (ArrayList)Util.func_200696_a(new ArrayList(loot), it -> it.add(stack.copy()));
    }

    @ZenCodeType.Method
    public static ILootModifier addAll(IItemStack ... stacks) {
        List stacksToAdd = CommonLootModifiers.notEmpty(Arrays.stream(stacks)).collect(Collectors.toList());
        return (loot, context) -> (ArrayList)Util.func_200696_a(new ArrayList(loot), it -> it.addAll(stacksToAdd.stream().map(IItemStack::copy).collect(Collectors.toList())));
    }

    @ZenCodeType.Method
    public static ILootModifier replaceWith(IIngredient target, IItemStack replacement) {
        return CommonLootModifiers.streaming((loot, context) -> CommonLootModifiers.replacing(loot, target, replacement));
    }

    @ZenCodeType.Method
    public static ILootModifier replaceAllWith(Map<IIngredient, IItemStack> replacementMap) {
        return CommonLootModifiers.chaining(replacementMap.entrySet().stream().map(it -> CommonLootModifiers.replaceWith((IIngredient)it.getKey(), (IItemStack)it.getValue())));
    }

    @ZenCodeType.Method
    public static ILootModifier replaceStackWith(IItemStack target, IItemStack replacement) {
        return CommonLootModifiers.streaming((loot, context) -> CommonLootModifiers.replacingExactly(loot, target, replacement));
    }

    @ZenCodeType.Method
    public static ILootModifier replaceAllStacksWith(Map<IItemStack, IItemStack> replacementMap) {
        return CommonLootModifiers.chaining(replacementMap.entrySet().stream().map(it -> CommonLootModifiers.replaceStackWith((IItemStack)it.getKey(), (IItemStack)it.getValue())));
    }

    @ZenCodeType.Method
    public static ILootModifier remove(IIngredient target) {
        return CommonLootModifiers.replaceWith(target, MCItemStack.EMPTY.get());
    }

    @ZenCodeType.Method
    public static ILootModifier removeAll(IIngredient ... targets) {
        return CommonLootModifiers.chaining(Arrays.stream(targets).map(CommonLootModifiers::remove));
    }

    @ZenCodeType.Method
    public static ILootModifier clearLoot() {
        return (ILootModifier)LOOT_CLEARING_MODIFIER.get();
    }

    @ZenCodeType.Method
    public static ILootModifier chaining(ILootModifier ... modifiers) {
        return CommonLootModifiers.chaining(Arrays.stream(modifiers));
    }

    private static ILootModifier streaming(BiFunction<Stream<IItemStack>, LootContext, Stream<IItemStack>> consumer) {
        return (loot, context) -> ((Stream)consumer.apply(loot.stream(), context)).collect(Collectors.toList());
    }

    private static ILootModifier chaining(Stream<ILootModifier> chain) {
        return chain.reduce((ILootModifier)IDENTITY.get(), (first, second) -> (loot, context) -> second.applyModifier(first.applyModifier(loot, context), context));
    }

    private static Stream<IItemStack> notEmpty(Stream<IItemStack> stream) {
        return stream.filter(it -> !it.isEmpty());
    }

    private static Stream<IItemStack> replacing(Stream<IItemStack> stream, IIngredient from, IItemStack to) {
        return CommonLootModifiers.notEmpty(stream.map(it -> from.matches((IItemStack)it) ? to.copy() : it));
    }

    private static Stream<IItemStack> replacingExactly(Stream<IItemStack> stream, IItemStack from, IItemStack to) {
        return stream.flatMap(it -> CommonLootModifiers.notEmpty((from.matches((IItemStack)it) ? CommonLootModifiers.replacingExactly(it, from, to) : Collections.singleton(it)).stream()));
    }

    private static List<IItemStack> replacingExactly(IItemStack original, IItemStack from, IItemStack to) {
        return Arrays.asList(to.copy().setAmount(original.getAmount() / from.getAmount()), original.copy().setAmount(original.getAmount() % from.getAmount()));
    }
}

