/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.modifiers;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.loot.modifiers.ILootModifier;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.loot.CTLootManager;
import com.blamejared.crafttweaker.impl.loot.conditions.CTLootConditionBuilder;
import com.blamejared.crafttweaker.impl.loot.conditions.vanilla.EntityPropertiesLootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl.loot.conditions.vanilla.KilledByPlayerLootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl.loot.modifiers.CommonLootModifiers;
import com.blamejared.crafttweaker.impl.predicate.TargetedEntity;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.Consumer;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/loot/modifiers/EntityTypeExpansion")
@ZenCodeType.Expansion(value="crafttweaker.api.entity.MCEntityType")
@ZenRegister
public final class ModifierEntityExpansion {
    @ZenCodeType.Method
    public static void addDrop(MCEntityType internal, String uniqueId, IItemStack stack) {
        ModifierEntityExpansion.addLootModifier(internal, uniqueId, CommonLootModifiers.add(stack));
    }

    @ZenCodeType.Method
    public static void addDrops(MCEntityType internal, String uniqueId, IItemStack ... stacks) {
        ModifierEntityExpansion.addLootModifier(internal, uniqueId, CommonLootModifiers.addAll(stacks));
    }

    @ZenCodeType.Method
    public static void addLootModifier(MCEntityType internal, String name, ILootModifier modifier) {
        CTLootManager.LOOT_MANAGER.getModifierManager().register(name, CTLootConditionBuilder.create().add(EntityPropertiesLootConditionTypeBuilder.class, ModifierEntityExpansion.makeForType(internal)), modifier);
    }

    @ZenCodeType.Method
    public static void addPlayerOnlyDrop(MCEntityType internal, String uniqueId, IItemStack stack) {
        ModifierEntityExpansion.addPlayerOnlyLootModifier(internal, uniqueId, CommonLootModifiers.add(stack));
    }

    @ZenCodeType.Method
    public static void addPlayerOnlyDrops(MCEntityType internal, String uniqueId, IItemStack ... stacks) {
        ModifierEntityExpansion.addPlayerOnlyLootModifier(internal, uniqueId, CommonLootModifiers.addAll(stacks));
    }

    @ZenCodeType.Method
    public static void addPlayerOnlyLootModifier(MCEntityType internal, String name, ILootModifier modifier) {
        CTLootManager.LOOT_MANAGER.getModifierManager().register(name, CTLootConditionBuilder.create().add(KilledByPlayerLootConditionTypeBuilder.class).add(EntityPropertiesLootConditionTypeBuilder.class, ModifierEntityExpansion.makeForType(internal)), modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponOnlyDrop(MCEntityType internal, String uniqueId, IItemStack weapon, IItemStack stack) {
        ModifierEntityExpansion.addWeaponOnlyLootModifier(internal, uniqueId, weapon, CommonLootModifiers.add(stack));
    }

    @ZenCodeType.Method
    public static void addWeaponOnlyDrops(MCEntityType internal, String uniqueId, IItemStack weapon, IItemStack ... stacks) {
        ModifierEntityExpansion.addWeaponOnlyLootModifier(internal, uniqueId, weapon, CommonLootModifiers.addAll(stacks));
    }

    @ZenCodeType.Method
    public static void addWeaponOnlyLootModifier(MCEntityType internal, String name, IItemStack weapon, ILootModifier modifier) {
        ModifierEntityExpansion.addWeaponOnlyLootModifier(internal, name, weapon, false, modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponOnlyLootModifier(MCEntityType internal, String name, IItemStack weapon, boolean matchDamage, ILootModifier modifier) {
        ModifierEntityExpansion.addWeaponOnlyLootModifier(internal, name, weapon, matchDamage, false, modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponOnlyLootModifier(MCEntityType internal, String name, IItemStack weapon, boolean matchDamage, boolean matchNbt, ILootModifier modifier) {
        CTLootManager.LOOT_MANAGER.getModifierManager().register(name, CTLootConditionBuilder.create().add(EntityPropertiesLootConditionTypeBuilder.class, ModifierEntityExpansion.makeForType(internal)).add(EntityPropertiesLootConditionTypeBuilder.class, ModifierEntityExpansion.makeForWeapon(weapon, matchDamage, matchNbt)), modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponAndPlayerOnlyDrop(MCEntityType internal, String uniqueId, IItemStack weapon, IItemStack stack) {
        ModifierEntityExpansion.addWeaponAndPlayerOnlyLootModifier(internal, uniqueId, weapon, CommonLootModifiers.add(stack));
    }

    @ZenCodeType.Method
    public static void addWeaponAndPlayerOnlyDrops(MCEntityType internal, String uniqueId, IItemStack weapon, IItemStack ... stacks) {
        ModifierEntityExpansion.addWeaponAndPlayerOnlyLootModifier(internal, uniqueId, weapon, CommonLootModifiers.addAll(stacks));
    }

    @ZenCodeType.Method
    public static void addWeaponAndPlayerOnlyLootModifier(MCEntityType internal, String name, IItemStack weapon, ILootModifier modifier) {
        ModifierEntityExpansion.addWeaponAndPlayerOnlyLootModifier(internal, name, weapon, false, modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponAndPlayerOnlyLootModifier(MCEntityType internal, String name, IItemStack weapon, boolean matchDamage, ILootModifier modifier) {
        ModifierEntityExpansion.addWeaponAndPlayerOnlyLootModifier(internal, name, weapon, matchDamage, false, modifier);
    }

    @ZenCodeType.Method
    public static void addWeaponAndPlayerOnlyLootModifier(MCEntityType internal, String name, IItemStack weapon, boolean matchDamage, boolean matchNbt, ILootModifier modifier) {
        CTLootManager.LOOT_MANAGER.getModifierManager().register(name, CTLootConditionBuilder.create().add(KilledByPlayerLootConditionTypeBuilder.class).add(EntityPropertiesLootConditionTypeBuilder.class, ModifierEntityExpansion.makeForType(internal)).add(EntityPropertiesLootConditionTypeBuilder.class, ModifierEntityExpansion.makeForWeapon(weapon, matchDamage, matchNbt)), modifier);
    }

    private static Consumer<EntityPropertiesLootConditionTypeBuilder> makeForType(MCEntityType type) {
        return builder -> builder.withTargetedEntity(TargetedEntity.ACTOR).withPredicate(entity -> entity.withEntityTypePredicate(entityType -> entityType.withType(type)));
    }

    private static Consumer<EntityPropertiesLootConditionTypeBuilder> makeForWeapon(IItemStack weapon, boolean matchDamage, boolean matchNbt) {
        return builder -> builder.withTargetedEntity(TargetedEntity.KILLER).withPredicate(entity -> entity.withEquipmentPredicate(equipment -> equipment.withItemInHand(item -> item.matching(weapon, matchDamage, false, matchNbt))));
    }
}

