/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.native_types;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.native_types.CrTNativeTypeInfo;
import com.blamejared.crafttweaker_annotations.annotations.NativeConstructor;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NativeTypeRegistry {
    private final Map<Class<?>, CrTNativeTypeInfo> nativeTypeInfos = new HashMap();

    private static Class<?>[] convertConstructorToClassArray(NativeConstructor nativeConstructor) {
        return (Class[])Arrays.stream(nativeConstructor.value()).map(NativeConstructor.ConstructorParameter::type).toArray(Class[]::new);
    }

    public void addNativeType(NativeTypeRegistration registration) {
        Class<?> vanillaClass = registration.value();
        String crtName = registration.zenCodeName();
        List<Class<?>[]> constructors = this.getNativeConstructors(registration);
        if (this.nativeTypeInfos.containsKey(vanillaClass) && !this.nativeTypeInfos.get(vanillaClass).getCraftTweakerName().equals(crtName)) {
            String format = "Trying to register vanilla class '%s' twice with different names: '%s' and '%s'";
            CrTNativeTypeInfo existingNativeTypeInfo = this.nativeTypeInfos.get(vanillaClass);
            CraftTweakerAPI.logError("Trying to register vanilla class '%s' twice with different names: '%s' and '%s'", existingNativeTypeInfo.getCraftTweakerName(), crtName);
        } else {
            this.nativeTypeInfos.put(vanillaClass, new CrTNativeTypeInfo(vanillaClass, crtName, constructors));
        }
    }

    private List<Class<?>[]> getNativeConstructors(NativeTypeRegistration registration) {
        return Arrays.stream(registration.constructors()).map(NativeTypeRegistry::convertConstructorToClassArray).collect(Collectors.toList());
    }

    public boolean hasInfoFor(Class<?> clazz) {
        return this.nativeTypeInfos.containsKey(clazz);
    }

    public String getCrTNameFor(Class<?> clazz) {
        return this.getTypeInfoFor(clazz).getCraftTweakerName();
    }

    public Collection<CrTNativeTypeInfo> getNativeTypeInfos() {
        return this.nativeTypeInfos.values();
    }

    public CrTNativeTypeInfo getTypeInfoFor(Class<?> clazz) {
        return this.nativeTypeInfos.get(clazz);
    }
}

