/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.predicate;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.predicate.IVanillaWrappingPredicate;
import com.blamejared.crafttweaker.impl.predicate.IntRangePredicate;
import com.blamejared.crafttweaker.impl.predicate.TriState;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.MobEffectsPredicate;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.predicate.EffectData")
@Document(value="vanilla/api/predicate/EffectData")
public final class EffectData
extends IVanillaWrappingPredicate.AnyDefaulting<MobEffectsPredicate.InstancePredicate> {
    private IntRangePredicate amplifier = IntRangePredicate.unbounded();
    private IntRangePredicate duration = IntRangePredicate.unbounded();
    private TriState ambient = TriState.UNSET;
    private TriState visible = TriState.UNSET;

    public EffectData() {
        super(MobEffectsPredicate.InstancePredicate::new);
    }

    @ZenCodeType.Method
    public EffectData withMinimumAmplifier(int min) {
        this.amplifier = IntRangePredicate.mergeLowerBound(this.amplifier, min);
        return this;
    }

    @ZenCodeType.Method
    public EffectData withMaximumAmplifier(int max) {
        this.amplifier = IntRangePredicate.mergeUpperBound(this.amplifier, max);
        return this;
    }

    @ZenCodeType.Method
    public EffectData withBoundedAmplifier(int min, int max) {
        this.amplifier = IntRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public EffectData withExactAmplifier(int value) {
        return this.withBoundedAmplifier(value, value);
    }

    @ZenCodeType.Method
    public EffectData withMinimumDuration(int min) {
        this.duration = IntRangePredicate.mergeLowerBound(this.duration, min);
        return this;
    }

    @ZenCodeType.Method
    public EffectData withMaximumDuration(int max) {
        this.duration = IntRangePredicate.mergeUpperBound(this.duration, max);
        return this;
    }

    @ZenCodeType.Method
    public EffectData withBoundedDuration(int min, int max) {
        this.duration = IntRangePredicate.bounded(min, max);
        return this;
    }

    @ZenCodeType.Method
    public EffectData withExactDuration(int value) {
        return this.withBoundedDuration(value, value);
    }

    @ZenCodeType.Method
    public EffectData withAmbient() {
        this.ambient = TriState.TRUE;
        return this;
    }

    @ZenCodeType.Method
    public EffectData withoutAmbient() {
        this.ambient = TriState.FALSE;
        return this;
    }

    @ZenCodeType.Method
    public EffectData withVisibility() {
        this.visible = TriState.TRUE;
        return this;
    }

    @ZenCodeType.Method
    public EffectData withInvisibility() {
        this.visible = TriState.FALSE;
        return this;
    }

    @Override
    public boolean isAny() {
        return this.amplifier.isAny() && this.duration.isAny() && this.ambient.isUnset() && this.visible.isUnset();
    }

    @Override
    public MobEffectsPredicate.InstancePredicate toVanilla() {
        return new MobEffectsPredicate.InstancePredicate((MinMaxBounds.IntBound)this.amplifier.toVanillaPredicate(), (MinMaxBounds.IntBound)this.duration.toVanillaPredicate(), this.ambient.toBoolean(), this.visible.toBoolean());
    }
}

