/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipes;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.GatherReplacementExclusionEvent;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.zencode.impl.util.PositionUtil;
import com.blamejared.crafttweaker.impl.brackets.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.impl.recipes.replacement.FullIngredientReplacementRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.IngredientReplacementRule;
import com.blamejared.crafttweaker.impl.recipes.replacement.ReplacerAction;
import com.blamejared.crafttweaker.impl.recipes.replacement.StackTargetingReplacementRule;
import com.blamejared.crafttweaker.impl.recipes.wrappers.WrapperRecipe;
import com.blamejared.crafttweaker.impl.util.NameUtils;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.Event;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.recipe.Replacer")
@Document(value="vanilla/api/recipe/Replacer")
public final class Replacer {
    private static final Function<ResourceLocation, ResourceLocation> DEFAULT_REPLACER = id -> NameUtils.isAutogeneratedName(id) ? id : NameUtils.generateNameFrom(id.func_110624_b() + "." + id.func_110623_a());
    private static final Supplier<BiFunction<ResourceLocation, String, String>> DEFAULT_CUSTOM_FUNCTION = Lazy.concurrentOf(() -> (id, original) -> original);
    private static final Map<IRecipeManager, Collection<ResourceLocation>> DEFAULT_EXCLUSIONS = new HashMap<IRecipeManager, Collection<ResourceLocation>>();
    private final Collection<IRecipeManager> targetedManagers;
    private final Collection<? extends IRecipe<?>> targetedRecipes;
    private final List<IReplacementRule> rules;
    private final Map<ResourceLocation, String> userRenames;
    private final Set<ResourceLocation> userExclusionList;
    private BiFunction<ResourceLocation, String, String> userRenamingFunction;

    private Replacer(Collection<? extends IRecipe<?>> recipes, Collection<IRecipeManager> managers) {
        this.targetedManagers = Collections.unmodifiableCollection(managers);
        this.targetedRecipes = Collections.unmodifiableCollection(recipes);
        this.rules = new ArrayList<IReplacementRule>();
        this.userRenames = new TreeMap<ResourceLocation, String>();
        this.userExclusionList = new HashSet<ResourceLocation>();
        this.userRenamingFunction = null;
    }

    @ZenCodeType.Method
    public static Replacer forRecipes(WrapperRecipe ... recipes) {
        if (recipes.length <= 0) {
            throw new IllegalArgumentException("Unable to create a replacer without any targeted recipes");
        }
        return new Replacer(Arrays.stream(recipes).map(WrapperRecipe::getRecipe).collect(Collectors.toSet()), Collections.emptyList());
    }

    @ZenCodeType.Method
    public static Replacer forTypes(IRecipeManager ... managers) {
        if (managers.length <= 0) {
            throw new IllegalArgumentException("Unable to create a replacer without any targeted recipe types");
        }
        return new Replacer(Collections.emptyList(), new HashSet<IRecipeManager>(Arrays.asList(managers)));
    }

    @ZenCodeType.Method
    public static Replacer forAllTypes() {
        return Replacer.forAllTypesExcluding(new IRecipeManager[0]);
    }

    @ZenCodeType.Method
    public static Replacer forAllTypesExcluding(IRecipeManager ... managers) {
        List<IRecipeManager> managerList = Arrays.asList(managers);
        return new Replacer(Collections.emptyList(), RecipeTypeBracketHandler.getManagerInstances().stream().filter(manager -> !managerList.contains(manager)).collect(Collectors.toSet()));
    }

    @ZenCodeType.Method
    public Replacer excluding(ResourceLocation ... recipes) {
        this.userExclusionList.addAll(Arrays.asList(recipes));
        return this;
    }

    @ZenCodeType.Method
    public Replacer replace(IIngredient from, IIngredient to) {
        if (from instanceof IItemStack) {
            return this.replace((IItemStack)from, to);
        }
        return this.addReplacementRule(IngredientReplacementRule.create(from, to));
    }

    @ZenCodeType.Method(value="replaceStack")
    public Replacer replace(IItemStack from, IIngredient to) {
        return this.addReplacementRule(StackTargetingReplacementRule.create(from, to));
    }

    @ZenCodeType.Method
    public Replacer replaceFully(IIngredient from, IIngredient to) {
        return this.addReplacementRule(FullIngredientReplacementRule.create(from, to));
    }

    @ZenCodeType.Method
    public Replacer explicitlyRename(ResourceLocation oldName, String newName) {
        String actualNewName = this.fix(newName, oldName);
        if (this.userRenames.containsKey(oldName) && !this.userRenames.get(oldName).equals(actualNewName)) {
            CraftTweakerAPI.logError("The same old name '%s' has been specified twice for renaming with two different strings '%s' and '%s': only the former will apply", oldName, this.userRenames.get(oldName), newName);
            return this;
        }
        this.userRenames.put(oldName, actualNewName);
        return this;
    }

    @ZenCodeType.Method
    public Replacer useForRenaming(BiFunction<ResourceLocation, String, String> function) {
        if (this.userRenamingFunction != null) {
            CodePosition position = PositionUtil.getZCScriptPositionFromStackTrace();
            CraftTweakerAPI.logWarning("%sA renaming function has already been specified for this replacer: the old one will be replaced", position == CodePosition.UNKNOWN ? "" : position + ": ");
        }
        this.userRenamingFunction = function;
        return this;
    }

    @ZenCodeType.Method
    public void execute() {
        if (this.rules.isEmpty()) {
            return;
        }
        CraftTweakerAPI.apply(new ReplacerAction(this.targetedManagers, this.targetedRecipes, Collections.unmodifiableList(this.rules), this.targetedManagers.stream().flatMap(manager -> DEFAULT_EXCLUSIONS.computeIfAbsent((IRecipeManager)manager, this::gatherDefaultExclusions).stream()).collect(Collectors.toSet()), Collections.unmodifiableCollection(this.userExclusionList), this.buildGeneratorFunction()));
    }

    public Replacer addReplacementRule(IReplacementRule rule) {
        if (rule == IReplacementRule.EMPTY) {
            return this;
        }
        this.rules.add(rule);
        return this;
    }

    private String fix(String newName, ResourceLocation oldName) {
        CodePosition position = PositionUtil.getZCScriptPositionFromStackTrace();
        return NameUtils.fixing(newName, (fixed, mistakes) -> CraftTweakerAPI.logWarning("%sInvalid recipe rename '%s' from '%s', mistakes:\n%s\nThe new rename '%s' will be used", position == CodePosition.UNKNOWN ? "" : position + ": ", newName, oldName, String.join((CharSequence)"\n", mistakes), fixed));
    }

    private Collection<ResourceLocation> gatherDefaultExclusions(IRecipeManager manager) {
        GatherReplacementExclusionEvent event = new GatherReplacementExclusionEvent(manager);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getExcludedRecipes();
    }

    private Function<ResourceLocation, ResourceLocation> buildGeneratorFunction() {
        if (this.userRenames.isEmpty() && this.userRenamingFunction == null) {
            return DEFAULT_REPLACER;
        }
        BiFunction<ResourceLocation, String, String> customFunction = Optional.ofNullable(this.userRenamingFunction).orElseGet(DEFAULT_CUSTOM_FUNCTION);
        BiFunction<String, String, ResourceLocation> fixer = (custom, original) -> {
            ResourceLocation originalRl = new ResourceLocation("crafttweaker", original);
            if (custom.equals(original) || NameUtils.isAutogeneratedName(originalRl)) {
                return originalRl;
            }
            return NameUtils.fromFixedName(custom, (fixed, mistakes) -> CraftTweakerAPI.logWarning("Invalid recipe rename '%s' specified in custom renaming function, mistakes:\n%s\nThe new rename will be '%s'", custom, String.join((CharSequence)"\n", mistakes), fixed));
        };
        return id -> {
            String original = Optional.ofNullable(this.userRenames.get(id)).orElseGet(() -> DEFAULT_REPLACER.apply((ResourceLocation)id).func_110623_a());
            return (ResourceLocation)fixer.apply((String)customFunction.apply((ResourceLocation)id, original), original);
        };
    }
}

