/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script;

import com.blamejared.crafttweaker.impl.script.ScriptRecipe;
import com.google.gson.JsonObject;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SerializerScript
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<ScriptRecipe> {
    static int MAX_SERIALIZED_SCRIPT_SIZE = 1073676289;
    public static final SerializerScript INSTANCE = new SerializerScript();

    public SerializerScript() {
        this.setRegistryName(new ResourceLocation("crafttweaker:scripts"));
    }

    public ScriptRecipe read(ResourceLocation recipeId, JsonObject json) {
        return new ScriptRecipe(recipeId, json.get("fileName").getAsString(), json.get("content").getAsString());
    }

    public ScriptRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        String fileName = buffer.func_218666_n();
        int parts = buffer.readShort();
        StringBuilder script = new StringBuilder();
        while (parts-- > 0) {
            script.append(buffer.func_218666_n());
        }
        return new ScriptRecipe(recipeId, fileName, script.toString());
    }

    public void write(PacketBuffer buffer, ScriptRecipe recipe) {
        String contents = recipe.getContent();
        if (contents.length() > MAX_SERIALIZED_SCRIPT_SIZE) {
            throw new IllegalArgumentException("Can't serialize scripts larger than " + MAX_SERIALIZED_SCRIPT_SIZE + " bytes. please split your script in smaller parts");
        }
        buffer.func_180714_a(recipe.getFileName());
        int parts = (int)Math.ceil((double)contents.length() / 32767.0);
        buffer.writeShort(parts);
        for (int i = 0; i < parts; ++i) {
            buffer.func_180714_a(contents.substring(i * Short.MAX_VALUE, Math.min((i + 1) * Short.MAX_VALUE, contents.length())));
        }
    }
}

