/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.tag.manager;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/tags/TagManager")
@ZenCodeType.Name(value="crafttweaker.api.tag.TagManager")
public interface TagManager<T>
extends CommandStringDisplayable {
    @Nonnull
    public Class<T> getElementClass();

    @ZenCodeType.Method
    default public MCTag<T> getTag(String name) {
        return this.getTag(new ResourceLocation(name));
    }

    @ZenCodeType.Method
    default public MCTag<T> getTag(ResourceLocation location) {
        return new MCTag(location, this);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean exists(String name) {
        return this.exists(new ResourceLocation(name));
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean exists(ResourceLocation location) {
        return this.getTagCollection().func_241833_a().containsKey(location);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="all")
    default public List<MCTag<T>> getAllTags() {
        return this.getTagCollection().func_241833_a().keySet().stream().map(tagLocation -> new MCTag((ResourceLocation)tagLocation, this)).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    default public List<MCTag<T>> getAllTagsFor(T element) {
        return this.getAllTags().stream().filter(tag -> tag.contains(element)).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tagType")
    public String getTagFolder();

    @Override
    default public String getCommandString() {
        return "<tagManager:" + this.getTagFolder() + ">";
    }

    public void addElements(MCTag<T> var1, List<T> var2);

    public void removeElements(MCTag<T> var1, List<T> var2);

    public List<T> getElementsInTag(MCTag<T> var1);

    @Nullable
    default public ITag<?> getInternal(MCTag<T> theTag) {
        return this.getTagCollection().func_199910_a(theTag.getIdInternal());
    }

    public ITagCollection<?> getTagCollection();
}

