/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl_native.entity;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.util.MCDirection;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/entity/MCEntity")
@NativeTypeRegistration(value=Entity.class, zenCodeName="crafttweaker.api.entity.MCEntity")
public class ExpandEntity {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="world")
    public static World getWorld(Entity internal) {
        return internal.field_70170_p;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="air")
    public static int getAir(Entity internal) {
        return internal.func_70086_ai();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="air")
    public static void setAir(Entity internal, int air) {
        internal.func_70050_g(air);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="position")
    public static BlockPos getPosition(Entity internal) {
        return internal.func_233580_cy_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="spectator")
    public static boolean isSpectator(Entity internal) {
        return internal.func_175149_v();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="type")
    public static MCEntityType getType(Entity internal) {
        return new MCEntityType(internal.func_200600_R());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="id")
    public static int getEntityId(Entity internal) {
        return internal.func_145782_y();
    }

    @Deprecated
    @ZenCodeType.Method
    public static void setEntityId(Entity internal, int id) {
        internal.func_145769_d(id);
        CraftTweakerAPI.logWarning("Entity IDs should not be settable! This method is marked for removal!", new Object[0]);
    }

    @ZenCodeType.Method
    public static Set<String> getTags(Entity internal) {
        return internal.func_184216_O();
    }

    @ZenCodeType.Method
    public static boolean addTag(Entity internal, String tag) {
        return internal.func_184211_a(tag);
    }

    @ZenCodeType.Method
    public static boolean removeTag(Entity internal, String tag) {
        return internal.func_184197_b(tag);
    }

    @ZenCodeType.Method
    public static void onKillCommand(Entity internal) {
        internal.func_174812_G();
    }

    @ZenCodeType.Method
    public static boolean isEntityInRange(Entity internal, Entity entity, double distance) {
        return internal.func_233562_a_(entity, distance);
    }

    @ZenCodeType.Method
    public static void setPosition(Entity internal, double x, double y, double z) {
        internal.func_70107_b(x, y, z);
    }

    @ZenCodeType.Method
    public static int getMaxInPortalTime(Entity internal) {
        return internal.func_82145_z();
    }

    @ZenCodeType.Method
    public static void setFire(Entity internal, int seconds) {
        internal.func_70015_d(seconds);
    }

    @ZenCodeType.Method
    public static void forceFireTicks(Entity internal, int ticks) {
        internal.func_241209_g_(ticks);
    }

    @ZenCodeType.Method
    public static int getFireTimer(Entity internal) {
        return internal.func_223314_ad();
    }

    @ZenCodeType.Method
    public static void extinguish(Entity internal) {
        internal.func_70066_B();
    }

    @ZenCodeType.Method
    public static boolean isOffsetPositionInLiquid(Entity internal, double x, double y, double z) {
        return internal.func_70038_c(x, y, z);
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="onGround")
    public static void setOnGround(Entity internal, boolean grounded) {
        internal.func_230245_c_(grounded);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="onGround")
    public static boolean isOnGround(Entity internal) {
        return internal.func_233570_aj_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="silent")
    public static boolean isSilent(Entity internal) {
        return internal.func_174814_R();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="silent")
    public static void setSilent(Entity internal, boolean isSilent) {
        internal.func_174810_b(isSilent);
    }

    @ZenCodeType.Method
    public static boolean hasNoGravity(Entity internal) {
        return internal.func_189652_ae();
    }

    @ZenCodeType.Method
    public static void setNoGravity(Entity internal, boolean noGravity) {
        internal.func_189654_d(noGravity);
    }

    @ZenCodeType.Method
    public static boolean isImmuneToFire(Entity internal) {
        return internal.func_230279_az_();
    }

    @ZenCodeType.Method
    public static boolean onLivingFall(Entity internal, float distance, float damageMultiplier) {
        return internal.func_225503_b_(distance, damageMultiplier);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="inWater")
    public static boolean isInWater(Entity internal) {
        return internal.func_70090_H();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isWet")
    public static boolean isWet(Entity internal) {
        return internal.func_70026_G();
    }

    @ZenCodeType.Method
    public static boolean isInWaterRainOrBubbleColumn(Entity internal) {
        return internal.func_203008_ap();
    }

    @ZenCodeType.Method
    public static boolean isInWaterOrBubbleColumn(Entity internal) {
        return internal.func_203005_aq();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="canSwim")
    public static boolean canSwim(Entity internal) {
        return internal.func_204231_K();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="inLava")
    public static boolean isInLava(Entity internal) {
        return internal.func_180799_ab();
    }

    @ZenCodeType.Method
    public static float getBrightness(Entity internal) {
        return internal.func_70013_c();
    }

    @ZenCodeType.Method
    public static void moveForced(Entity internal, double x, double y, double z) {
        internal.func_225653_b_(x, y, z);
    }

    @ZenCodeType.Method
    public static void forceSetPosition(Entity internal, double x, double y, double z) {
        internal.func_226286_f_(x, y, z);
    }

    @ZenCodeType.Method
    public static float getDistance(Entity internal, Entity other) {
        return internal.func_70032_d(other);
    }

    @ZenCodeType.Method
    public static double getDistanceSq(Entity internal, double x, double y, double z) {
        return internal.func_70092_e(x, y, z);
    }

    @ZenCodeType.Method
    public static double getDistanceSq(Entity internal, Entity other) {
        return internal.func_70068_e(other);
    }

    @ZenCodeType.Method
    public static void onCollideWithPlayer(Entity internal, PlayerEntity playerEntity) {
        internal.func_70100_b_(playerEntity);
    }

    @ZenCodeType.Method
    public static void applyEntityCollision(Entity internal, Entity other) {
        internal.func_70108_f(other);
    }

    @ZenCodeType.Method
    public static void addVelocity(Entity internal, double x, double y, double z) {
        internal.func_70024_g(x, y, z);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="name")
    public static String getName(Entity internal) {
        return internal.func_200200_C_().getString();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="facingDirections")
    public static MCDirection[] getFacingDirections(Entity internal) {
        return (MCDirection[])Arrays.stream(Direction.func_196054_a((Entity)internal)).map(MCDirection::get).toArray(MCDirection[]::new);
    }

    @ZenCodeType.Method
    public static void changeDimension(Entity internal, ServerWorld world) {
        internal.func_241206_a_(world);
    }

    @ZenCodeType.Method
    public static void teleportKeepLoaded(Entity internal, double x, double y, double z) {
        internal.func_223102_j(x, y, z);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="uuid")
    public static String getUUID(Entity internal) {
        return internal.func_110124_au().toString();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="data")
    public static MapData getData(Entity internal) {
        return new MapData(internal.serializeNBT());
    }

    @ZenCodeType.Method
    public static void updateData(Entity internal, MapData data) {
        internal.deserializeNBT(internal.serializeNBT().func_197643_a(data.getInternal()));
    }
}

