/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel;

import java.util.ArrayList;
import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.Taggable;
import org.openzen.zenscript.codemodel.AccessScope;
import org.openzen.zenscript.codemodel.Module;
import org.openzen.zenscript.codemodel.annotations.DefinitionAnnotation;
import org.openzen.zenscript.codemodel.definition.AliasDefinition;
import org.openzen.zenscript.codemodel.definition.DefinitionVisitor;
import org.openzen.zenscript.codemodel.definition.DefinitionVisitorWithContext;
import org.openzen.zenscript.codemodel.definition.ExpansionDefinition;
import org.openzen.zenscript.codemodel.definition.InterfaceDefinition;
import org.openzen.zenscript.codemodel.definition.MemberCollector;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.member.ConstructorMember;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.member.InnerDefinitionMember;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;

public abstract class HighLevelDefinition
extends Taggable {
    public final CodePosition position;
    public final Module module;
    public final ZSPackage pkg;
    public final String name;
    public final int modifiers;
    public final List<IDefinitionMember> members = new ArrayList<IDefinitionMember>();
    public TypeParameter[] typeParameters = TypeParameter.NONE;
    public DefinitionAnnotation[] annotations = DefinitionAnnotation.NONE;
    public HighLevelDefinition outerDefinition;
    private TypeID superType;

    public HighLevelDefinition(CodePosition position, Module module, ZSPackage pkg, String name, int modifiers, HighLevelDefinition outerDefinition) {
        if (module == null) {
            throw new NullPointerException();
        }
        this.position = position;
        this.module = module;
        this.pkg = pkg;
        this.name = name;
        this.modifiers = modifiers;
        this.outerDefinition = outerDefinition;
        if (pkg != null) {
            pkg.register(this);
        }
    }

    public String getFullName() {
        return this.pkg.fullName + '.' + this.name;
    }

    public TypeID getSuperType() {
        return this.superType;
    }

    public void setSuperType(TypeID superType) {
        this.superType = superType;
    }

    public boolean isSubclassOf(HighLevelDefinition other) {
        if (this.superType.isDefinition(other)) {
            return true;
        }
        if (this.superType == null || !(this.superType instanceof DefinitionTypeID)) {
            return false;
        }
        DefinitionTypeID superDefinition = (DefinitionTypeID)this.superType;
        return superDefinition.definition.isSubclassOf(other);
    }

    public int getNumberOfGenericParameters() {
        return this.typeParameters == null ? 0 : this.typeParameters.length;
    }

    public void setOuterDefinition(HighLevelDefinition outerDefinition) {
        this.outerDefinition = outerDefinition;
    }

    public boolean isExpansion() {
        return this instanceof ExpansionDefinition;
    }

    public boolean isInnerDefinition() {
        return this.outerDefinition != null;
    }

    public boolean isInterface() {
        return this instanceof InterfaceDefinition;
    }

    public boolean isAlias() {
        return this instanceof AliasDefinition;
    }

    public void addMember(IDefinitionMember member) {
        if (!this.members.contains(member)) {
            this.members.add(member);
        }
    }

    public void collectMembers(MemberCollector collector) {
        for (IDefinitionMember member : this.members) {
            collector.member(member);
        }
    }

    public void setTypeParameters(TypeParameter[] typeParameters) {
        this.typeParameters = typeParameters;
    }

    public AccessScope getAccessScope() {
        return new AccessScope(this.module, this);
    }

    public List<FieldMember> getFields() {
        ArrayList<FieldMember> fields = new ArrayList<FieldMember>();
        for (IDefinitionMember member : this.members) {
            if (!(member instanceof FieldMember)) continue;
            fields.add((FieldMember)member);
        }
        return fields;
    }

    public boolean hasEmptyConstructor() {
        for (IDefinitionMember member : this.members) {
            if (!(member instanceof ConstructorMember) || ((ConstructorMember)member).header.parameters.length != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isStatic() {
        return (this.modifiers & 0x80) > 0;
    }

    public void normalize(TypeScope scope) {
        ArrayList<FieldMember> fields = new ArrayList<FieldMember>();
        for (IDefinitionMember member : this.members) {
            member.normalize(scope);
            if (!(member instanceof FieldMember)) continue;
            fields.add((FieldMember)member);
        }
        for (FieldMember field : fields) {
            if (field.autoGetter != null) {
                this.members.add(field.autoGetter);
            }
            if (field.autoSetter == null) continue;
            this.members.add(field.autoSetter);
        }
    }

    public abstract <T> T accept(DefinitionVisitor<T> var1);

    public abstract <C, R> R accept(C var1, DefinitionVisitorWithContext<C, R> var2);

    public HighLevelDefinition getInnerType(String name) {
        for (IDefinitionMember member : this.members) {
            if (!(member instanceof InnerDefinitionMember)) continue;
            InnerDefinitionMember inner = (InnerDefinitionMember)member;
            if (!inner.innerDefinition.name.equals(name)) continue;
            return inner.innerDefinition;
        }
        return null;
    }

    public boolean isOuterOf(HighLevelDefinition definition) {
        if (definition.outerDefinition == this) {
            return true;
        }
        if (definition.outerDefinition == null) {
            return false;
        }
        return this.isOuterOf(definition.outerDefinition);
    }
}

