/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.List;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.codemodel.type.TypeVisitorWithContext;

public class RangeTypeID
implements TypeID {
    public static final RangeTypeID INT = new RangeTypeID(null, BasicTypeID.INT);
    public static final RangeTypeID USIZE = new RangeTypeID(null, BasicTypeID.USIZE);
    public final TypeID baseType;
    private final RangeTypeID normalized;

    public RangeTypeID(GlobalTypeRegistry registry, TypeID baseType) {
        this.baseType = baseType;
        this.normalized = baseType.getNormalized().equals(baseType) ? this : registry.getRange(baseType.getNormalized());
    }

    @Override
    public RangeTypeID getNormalized() {
        return this.normalized;
    }

    @Override
    public TypeID instance(GenericMapper mapper) {
        return mapper.registry.getRange(this.baseType.instance(mapper));
    }

    @Override
    public <R> R accept(TypeVisitor<R> visitor) {
        return visitor.visitRange(this);
    }

    @Override
    public <C, R, E extends Exception> R accept(C context, TypeVisitorWithContext<C, R, E> visitor) throws E {
        return visitor.visitRange(context, this);
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isValueType() {
        return this.baseType.isValueType();
    }

    @Override
    public boolean hasInferenceBlockingTypeParameters(TypeParameter[] parameters) {
        return this.baseType.hasInferenceBlockingTypeParameters(parameters);
    }

    @Override
    public boolean hasDefaultValue() {
        return false;
    }

    @Override
    public void extractTypeParameters(List<TypeParameter> typeParameters) {
        this.baseType.extractTypeParameters(typeParameters);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + this.baseType.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeTypeID other = (RangeTypeID)obj;
        return this.baseType.equals(other.baseType);
    }

    public String toString() {
        return this.baseType.toString() + " .. " + this.baseType.toString();
    }
}

