/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.ScriptBlock;
import org.openzen.zenscript.codemodel.WhitespacePostComment;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.statement.Statement;
import org.openzen.zenscript.formatter.CommentFormatter;
import org.openzen.zenscript.formatter.DefinitionFormatter;
import org.openzen.zenscript.formatter.ExpressionFormatter;
import org.openzen.zenscript.formatter.ScriptFormattingSettings;
import org.openzen.zenscript.formatter.StatementFormatter;
import org.openzen.zenscript.formatter.TypeFormatter;
import org.openzen.zenscript.formattershared.Importer;

public class FileFormatter {
    private final ScriptFormattingSettings settings;

    public FileFormatter(ScriptFormattingSettings settings) {
        this.settings = settings;
    }

    public String format(ZSPackage pkg, ScriptBlock script, List<HighLevelDefinition> definitions) {
        FileImporter importer = new FileImporter(pkg);
        TypeFormatter typeFormatter = new TypeFormatter(this.settings, importer);
        ExpressionFormatter expressionFormatter = new ExpressionFormatter(this.settings, typeFormatter, "");
        ArrayList<DefinitionFormatter> definitionFormatters = new ArrayList<DefinitionFormatter>();
        for (HighLevelDefinition definition : definitions) {
            DefinitionFormatter definitionFormatter = new DefinitionFormatter(this.settings, typeFormatter, "");
            definition.accept(definitionFormatter);
            definitionFormatters.add(definitionFormatter);
        }
        StringBuilder scriptOutput = new StringBuilder();
        if (script != null) {
            StatementFormatter scriptFormatter = new StatementFormatter(scriptOutput, "", this.settings, expressionFormatter);
            for (Statement statement : script.statements) {
                statement.accept(scriptFormatter);
            }
        }
        StringBuilder output = new StringBuilder();
        importer.write(output);
        boolean first = true;
        for (DefinitionFormatter definition : definitionFormatters) {
            if (first) {
                first = false;
            } else {
                output.append("\n");
            }
            output.append(definition.toString());
        }
        if (script != null && script.statements.size() > 0) {
            if (definitionFormatters.size() > 0) {
                output.append("\n");
            }
            output.append(scriptOutput.toString().trim());
            WhitespacePostComment whitespacePostComment = script.getTag(WhitespacePostComment.class);
            if (whitespacePostComment != null) {
                for (String comment : CommentFormatter.format(whitespacePostComment.comments)) {
                    output.append("\n").append(comment);
                }
            }
        }
        return output.toString();
    }

    private class FileImporter
    implements Importer {
        private final ZSPackage pkg;
        private final Map<String, HighLevelDefinition> imports = new HashMap<String, HighLevelDefinition>();

        public FileImporter(ZSPackage pkg) {
            this.pkg = pkg;
        }

        public void write(StringBuilder output) {
            HashMap importsByPackage = new HashMap();
            for (HighLevelDefinition definition : this.imports.values()) {
                if (!importsByPackage.containsKey(definition.pkg)) {
                    importsByPackage.put(definition.pkg, new ArrayList());
                }
                ((List)importsByPackage.get(definition.pkg)).add(definition);
            }
            ArrayList sortedPackages = new ArrayList(importsByPackage.keySet());
            Collections.sort(sortedPackages, (a, b) -> a.fullName.compareTo(b.fullName));
            for (ZSPackage pkg : sortedPackages) {
                for (HighLevelDefinition definition : (List)importsByPackage.get(pkg)) {
                    output.append("import ").append(pkg.fullName).append('.').append(definition.name).append(";\n");
                }
            }
            if (this.imports.size() > 0) {
                output.append("\n");
            }
        }

        @Override
        public String importDefinition(HighLevelDefinition definition) {
            if (definition.pkg == this.pkg) {
                return definition.name;
            }
            if (this.imports.get(definition.name) == definition) {
                return definition.name;
            }
            if (this.imports.containsKey(definition.name) || this.pkg.contains(definition.name)) {
                return definition.pkg.fullName + '.' + definition.name;
            }
            this.imports.put(definition.name, definition);
            return definition.name;
        }
    }
}

