/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.validator.visitors;

import java.util.HashSet;
import java.util.Set;
import org.openzen.zenscript.codemodel.AccessScope;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.member.EnumConstantMember;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.statement.BlockStatement;
import org.openzen.zenscript.codemodel.statement.BreakStatement;
import org.openzen.zenscript.codemodel.statement.CatchClause;
import org.openzen.zenscript.codemodel.statement.ContinueStatement;
import org.openzen.zenscript.codemodel.statement.DoWhileStatement;
import org.openzen.zenscript.codemodel.statement.EmptyStatement;
import org.openzen.zenscript.codemodel.statement.ExpressionStatement;
import org.openzen.zenscript.codemodel.statement.ForeachStatement;
import org.openzen.zenscript.codemodel.statement.IfStatement;
import org.openzen.zenscript.codemodel.statement.InvalidStatement;
import org.openzen.zenscript.codemodel.statement.LockStatement;
import org.openzen.zenscript.codemodel.statement.ReturnStatement;
import org.openzen.zenscript.codemodel.statement.Statement;
import org.openzen.zenscript.codemodel.statement.StatementVisitor;
import org.openzen.zenscript.codemodel.statement.SwitchCase;
import org.openzen.zenscript.codemodel.statement.SwitchStatement;
import org.openzen.zenscript.codemodel.statement.ThrowStatement;
import org.openzen.zenscript.codemodel.statement.TryCatchStatement;
import org.openzen.zenscript.codemodel.statement.VarStatement;
import org.openzen.zenscript.codemodel.statement.WhileStatement;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.validator.ValidationLogEntry;
import org.openzen.zenscript.validator.Validator;
import org.openzen.zenscript.validator.analysis.ExpressionScope;
import org.openzen.zenscript.validator.analysis.StatementScope;
import org.openzen.zenscript.validator.visitors.ExpressionValidator;

public class StatementValidator
implements StatementVisitor<Void> {
    private final Validator validator;
    private final StatementScope scope;
    private final Set<String> variables = new HashSet<String>();
    public boolean constructorForwarded = false;
    private boolean firstStatement = true;

    public StatementValidator(Validator validator, StatementScope scope) {
        this.validator = validator;
        this.scope = scope;
    }

    @Override
    public Void visitBlock(BlockStatement block) {
        for (Statement statement : block.statements) {
            statement.accept(this);
        }
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitBreak(BreakStatement statement) {
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitContinue(ContinueStatement statement) {
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitDoWhile(DoWhileStatement statement) {
        if (statement.condition.type != BasicTypeID.BOOL) {
            this.validator.logError(ValidationLogEntry.Code.INVALID_CONDITION_TYPE, statement.position, "condition must be a boolean expression");
        }
        statement.condition.accept(new ExpressionValidator(this.validator, new StatementExpressionScope()));
        statement.content.accept(this);
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitEmpty(EmptyStatement statement) {
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitExpression(ExpressionStatement statement) {
        statement.expression.accept(new ExpressionValidator(this.validator, new StatementExpressionScope()));
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitForeach(ForeachStatement statement) {
        statement.list.accept(new ExpressionValidator(this.validator, new StatementExpressionScope()));
        statement.content.accept(this);
        for (VarStatement var : statement.loopVariables) {
            if (!this.variables.contains(var.name)) continue;
            this.validator.logError(ValidationLogEntry.Code.DUPLICATE_VARIABLE_NAME, var.position, "Duplicate variable name: " + var.name);
        }
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitIf(IfStatement statement) {
        this.validateCondition(statement.condition);
        statement.onThen.accept(this);
        if (statement.onElse != null) {
            statement.onElse.accept(this);
        }
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitInvalid(InvalidStatement statement) {
        this.validator.logError(ValidationLogEntry.Code.INVALID_STATEMENT, statement.position, statement.message);
        return null;
    }

    @Override
    public Void visitLock(LockStatement statement) {
        statement.object.accept(new ExpressionValidator(this.validator, new StatementExpressionScope()));
        statement.content.accept(this);
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitReturn(ReturnStatement statement) {
        if (this.scope.getFunctionHeader() == null) {
            this.validator.logError(ValidationLogEntry.Code.SCRIPT_CANNOT_RETURN, statement.position, "Cannot return from a script");
            return null;
        }
        if (statement.value != null) {
            statement.value.accept(new ExpressionValidator(this.validator, new StatementExpressionScope()));
            if (this.scope.getFunctionHeader().getReturnType() == BasicTypeID.VOID) {
                this.validator.logError(ValidationLogEntry.Code.INVALID_RETURN_TYPE, statement.position, "Function return type is void; cannot return a value");
            } else if (!statement.value.type.equals(this.scope.getFunctionHeader().getReturnType())) {
                this.validator.logError(ValidationLogEntry.Code.INVALID_RETURN_TYPE, statement.position, "Invalid return type: " + statement.value.type.toString());
            }
        } else if (this.scope.getFunctionHeader().getReturnType() != BasicTypeID.VOID) {
            this.validator.logError(ValidationLogEntry.Code.INVALID_RETURN_TYPE, statement.position, "Missing return value");
        }
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitSwitch(SwitchStatement statement) {
        statement.value.accept(new ExpressionValidator(this.validator, new StatementExpressionScope()));
        for (SwitchCase switchCase : statement.cases) {
            for (Statement caseStatement : switchCase.statements) {
                caseStatement.accept(this);
            }
        }
        return null;
    }

    @Override
    public Void visitThrow(ThrowStatement statement) {
        statement.value.accept(new ExpressionValidator(this.validator, new StatementExpressionScope()));
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitTryCatch(TryCatchStatement statement) {
        if (statement.resource != null) {
            if (this.variables.contains(statement.resource.name)) {
                this.validator.logError(ValidationLogEntry.Code.DUPLICATE_VARIABLE_NAME, statement.position, "Duplicate variable name: " + statement.resource.name);
            }
            if (statement.resource.initializer == null) {
                this.validator.logError(ValidationLogEntry.Code.TRY_CATCH_RESOURCE_REQUIRES_INITIALIZER, statement.position, "try with resource requires initializer");
            }
        }
        statement.content.accept(this);
        for (CatchClause catchClause : statement.catchClauses) {
            catchClause.content.accept(this);
        }
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitVar(VarStatement statement) {
        if (this.variables.contains(statement.name)) {
            this.validator.logError(ValidationLogEntry.Code.DUPLICATE_VARIABLE_NAME, statement.position, "Duplicate variable name: " + statement.name);
        }
        this.variables.add(statement.name);
        if (statement.initializer != null) {
            statement.initializer.accept(new ExpressionValidator(this.validator, new StatementExpressionScope()));
        }
        this.firstStatement = false;
        return null;
    }

    @Override
    public Void visitWhile(WhileStatement statement) {
        this.validateCondition(statement.condition);
        statement.content.accept(this);
        this.firstStatement = false;
        return null;
    }

    private void validateCondition(Expression condition) {
        condition.accept(new ExpressionValidator(this.validator, new StatementExpressionScope()));
        if (condition.type != BasicTypeID.BOOL) {
            this.validator.logError(ValidationLogEntry.Code.INVALID_CONDITION_TYPE, condition.position, "condition must be a boolean expression");
        }
    }

    private class StatementExpressionScope
    implements ExpressionScope {
        private StatementExpressionScope() {
        }

        @Override
        public boolean isConstructor() {
            return StatementValidator.this.scope.isConstructor();
        }

        @Override
        public boolean isFirstStatement() {
            return StatementValidator.this.firstStatement;
        }

        @Override
        public boolean hasThis() {
            return !StatementValidator.this.scope.isStatic();
        }

        @Override
        public boolean isFieldInitialized(FieldMember field) {
            return true;
        }

        @Override
        public void markConstructorForwarded() {
            StatementValidator.this.constructorForwarded = true;
        }

        @Override
        public boolean isEnumConstantInitialized(EnumConstantMember member) {
            return true;
        }

        @Override
        public boolean isLocalVariableInitialized(VarStatement variable) {
            return true;
        }

        @Override
        public boolean isStaticInitializer() {
            return StatementValidator.this.scope.isStaticInitializer();
        }

        @Override
        public HighLevelDefinition getDefinition() {
            return StatementValidator.this.scope.getDefinition();
        }

        @Override
        public AccessScope getAccessScope() {
            return StatementValidator.this.scope.getAccessScope();
        }
    }
}

