/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.IGearComponent;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;

public interface IMaterial
extends IGearComponent<IMaterialInstance> {
    public String getPackName();

    public ResourceLocation getId();

    public IMaterialSerializer<?> getSerializer();

    @Nullable
    public IMaterial getParent();

    default public Optional<IMaterial> getParentOptional() {
        return Optional.ofNullable(this.getParent());
    }

    @Deprecated
    default public Collection<IMaterialCategory> getCategories() {
        return this.getCategories(MaterialInstance.of(this));
    }

    public Collection<IMaterialCategory> getCategories(IMaterialInstance var1);

    @Deprecated
    default public int getTier(PartType partType) {
        return this.getTier(MaterialInstance.of(this), partType);
    }

    public int getTier(IMaterialInstance var1, PartType var2);

    public Optional<Ingredient> getPartSubstitute(PartType var1);

    public boolean hasPartSubstitutes();

    public boolean canSalvage();

    public boolean isSimple();

    public Set<PartType> getPartTypes(IMaterialInstance var1);

    public boolean allowedInPart(IMaterialInstance var1, PartType var2);

    default public void retainData(@Nullable IMaterial oldMaterial) {
    }

    public Collection<StatGearKey> getStatKeys(IMaterialInstance var1, PartType var2);

    @Nullable
    default public IMaterialDisplay getDisplayOverride(IMaterialInstance material) {
        return null;
    }

    @Nullable
    public ITextComponent getDisplayNamePrefix(ItemStack var1, PartType var2);

    public int getNameColor(IMaterialInstance var1, PartType var2, GearType var3);

    default public String getModelKey(IMaterialInstance material) {
        return SilentGear.shortenId(this.getId());
    }

    default public boolean isVisible(PartType partType) {
        return true;
    }

    default public ItemStack getDisplayItem(PartType type, int ticks) {
        ItemStack[] stacks = this.getIngredient().func_193365_a();
        if (stacks.length == 0) {
            return ItemStack.field_190927_a;
        }
        return stacks[ticks / 20 % stacks.length];
    }

    public void updateIngredient(SyncMaterialCraftingItemsPacket var1);

    @Override
    default public MaterialList getMaterials(IMaterialInstance instance) {
        return MaterialList.empty();
    }
}

