/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.part;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.gear.part.PartData;

public final class PartDataList
implements List<PartData> {
    private final List<PartData> list = new ArrayList<PartData>();

    private PartDataList() {
    }

    public static PartDataList empty() {
        return new PartDataList();
    }

    public static PartDataList of(Collection<PartData> c) {
        PartDataList ret = new PartDataList();
        ret.list.addAll(c);
        return ret;
    }

    public static PartDataList of(PartData ... parts) {
        PartDataList ret = new PartDataList();
        Collections.addAll(ret.list, parts);
        return ret;
    }

    @Deprecated
    public static PartDataList from(Collection<ItemStack> stacks) {
        PartDataList ret = new PartDataList();
        stacks.stream().map(PartData::from).filter(Objects::nonNull).forEach(ret.list::add);
        return ret;
    }

    @Deprecated
    public PartDataList getUniqueParts(boolean mainsOnly) {
        PartDataList result = PartDataList.of(new PartData[0]);
        for (PartData data : mainsOnly ? this.getMains() : this.list) {
            if (!result.stream().map(PartData::get).noneMatch(part -> part == data.get())) continue;
            result.add(data);
        }
        return result;
    }

    @Nullable
    public PartData getPrimaryMain() {
        for (PartData data : this.list) {
            if (data.getType() != PartType.MAIN) continue;
            return data;
        }
        return null;
    }

    public List<PartData> getMains() {
        return this.getPartsOfType(PartType.MAIN);
    }

    public List<PartData> getRods() {
        return this.getPartsOfType(PartType.ROD);
    }

    public List<PartData> getTips() {
        return this.getPartsOfType(PartType.TIP);
    }

    public List<PartData> getPartsOfType(PartType type) {
        return this.getParts(part -> part.getType() == type);
    }

    public List<PartData> getParts(Predicate<PartData> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PartData partData : this.list) {
            if (!predicate.test(partData)) continue;
            builder.add((Object)partData);
        }
        return builder.build();
    }

    public boolean addPart(IGearPart part) {
        return this.list.add(PartData.of(part));
    }

    public int getPartsWithTrait(ITrait trait) {
        int count = 0;
        block0: for (PartData part : this) {
            for (TraitInstance inst : part.getTraits()) {
                if (inst.getTrait() != trait) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    @Override
    public boolean add(PartData arg0) {
        return this.list.add(arg0);
    }

    @Override
    public void add(int arg0, PartData arg1) {
        this.list.add(arg0, arg1);
    }

    @Override
    public boolean addAll(Collection<? extends PartData> arg0) {
        return this.list.addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends PartData> arg1) {
        return this.list.addAll(arg0, arg1);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.list.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.list.containsAll(arg0);
    }

    @Override
    public PartData get(int arg0) {
        return this.list.get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        return this.list.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<PartData> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.list.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<PartData> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<PartData> listIterator(int arg0) {
        return this.list.listIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.list.remove(arg0);
    }

    @Override
    public PartData remove(int arg0) {
        return this.list.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.list.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.list.retainAll(arg0);
    }

    @Override
    public PartData set(int arg0, PartData arg1) {
        return this.list.set(arg0, arg1);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<PartData> subList(int arg0, int arg1) {
        return this.list.subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.list.toArray(arg0);
    }
}

