/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.material;

import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.material.MaterialDisplay;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.util.Const;

public class DefaultMaterialDisplay
extends MaterialDisplay {
    public static final DefaultMaterialDisplay INSTANCE = new DefaultMaterialDisplay();

    public DefaultMaterialDisplay() {
        super(Const.NULL_ID);
    }

    @Override
    public IMaterialLayerList getLayerList(GearType gearType, IPartData part, IMaterialInstance materialIn) {
        this.createMissingEntry(part);
        return super.getLayerList(gearType, part, materialIn);
    }

    @Override
    public int getLayerColor(GearType gearType, IPartData part, IMaterialInstance materialIn, int layer) {
        this.createMissingEntry(part);
        return 0xFFFFFF;
    }

    private void createMissingEntry(IPartData part) {
        PartGearKey key = PartGearKey.of(GearType.ALL, part.getType());
        if (!this.map.containsKey(key)) {
            PartTextures texture = part.getType().getDefaultTexture();
            if (texture != null) {
                this.map.put(key, new MaterialLayerList(new MaterialLayer(texture.getTexture(), part.getType(), 0, false)));
            } else {
                this.map.put(key, MaterialLayerList.DEFAULT);
            }
        }
    }
}

